/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iosco.cde.version3.price.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.PricePeriod;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=GetReportableStrikePricePeriodDefault.class)
public abstract class GetReportableStrikePricePeriod
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected drr.standards.iosco.cde.version2.price.functions.GetReportableStrikePricePeriod getReportableStrikePricePeriod;

    public List<? extends PricePeriod> evaluate(ReportableEventBase reportableEvent, PriceNotationEnum notation) {
        List reportablePeriod;
        List<PricePeriod.PricePeriodBuilder> reportablePeriodBuilder = this.doEvaluate(reportableEvent, notation);
        if (reportablePeriodBuilder == null) {
            reportablePeriod = null;
        } else {
            reportablePeriod = reportablePeriodBuilder.stream().map(PricePeriod::build).collect(Collectors.toList());
            this.objectValidator.validate(PricePeriod.class, reportablePeriod);
        }
        return reportablePeriod;
    }

    protected abstract List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEventBase var1, PriceNotationEnum var2);

    public static class GetReportableStrikePricePeriodDefault
    extends GetReportableStrikePricePeriod {
        @Override
        protected List<PricePeriod.PricePeriodBuilder> doEvaluate(ReportableEventBase reportableEvent, PriceNotationEnum notation) {
            ArrayList<PricePeriod.PricePeriodBuilder> reportablePeriod = new ArrayList<PricePeriod.PricePeriodBuilder>();
            return this.assignOutput(reportablePeriod, reportableEvent, notation);
        }

        protected List<PricePeriod.PricePeriodBuilder> assignOutput(List<PricePeriod.PricePeriodBuilder> reportablePeriod, ReportableEventBase reportableEvent, PriceNotationEnum notation) {
            reportablePeriod.addAll(this.toBuilder(this.getReportableStrikePricePeriod.evaluate(reportableEvent, notation)));
            return Optional.ofNullable(reportablePeriod).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

