/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso;

import com.rosetta.model.lib.annotations.RosettaEnum;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

@RosettaEnum(value="OptionTypeCode")
public enum OptionTypeCode {
    CALL("CALL", null),
    PUTO("PUTO", null),
    OTHR("OTHR", null);

    private static Map<String, OptionTypeCode> values;
    private final String rosettaName;
    private final String displayName;

    private OptionTypeCode(String rosettaName, String displayName) {
        this.rosettaName = rosettaName;
        this.displayName = displayName;
    }

    public static OptionTypeCode fromDisplayName(String name) {
        OptionTypeCode value = values.get(name);
        if (value == null) {
            throw new IllegalArgumentException("No enum constant with display name \"" + name + "\".");
        }
        return value;
    }

    public String toString() {
        return this.toDisplayString();
    }

    public String toDisplayString() {
        return this.displayName != null ? this.displayName : this.rosettaName;
    }

    static {
        ConcurrentHashMap<String, OptionTypeCode> map = new ConcurrentHashMap<String, OptionTypeCode>();
        for (OptionTypeCode instance : OptionTypeCode.values()) {
            map.put(instance.toDisplayString(), instance);
        }
        values = Collections.unmodifiableMap(map);
    }
}

