/*
 * Decompiled with CFR 0.152.
 */
package drr.standards.iso.functions;

import cdm.base.math.CapacityUnitEnum;
import cdm.base.math.FinancialUnitEnum;
import cdm.base.math.UnitType;
import cdm.base.math.WeatherUnitEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.functions.CapacityUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.FinancialUnitToISO20022UnitOfMeasure;
import drr.standards.iso.functions.WeatherUnitToISO20022UnitOfMeasure;
import javax.inject.Inject;

@ImplementedBy(value=UnitToISO20022UnitOfMeasureDefault.class)
public abstract class UnitToISO20022UnitOfMeasure
implements RosettaFunction {
    @Inject
    protected CapacityUnitToISO20022UnitOfMeasure capacityUnitToISO20022UnitOfMeasure;
    @Inject
    protected FinancialUnitToISO20022UnitOfMeasure financialUnitToISO20022UnitOfMeasure;
    @Inject
    protected WeatherUnitToISO20022UnitOfMeasure weatherUnitToISO20022UnitOfMeasure;

    public String evaluate(UnitType unit) {
        String unitOfMeasure = this.doEvaluate(unit);
        return unitOfMeasure;
    }

    protected abstract String doEvaluate(UnitType var1);

    public static class UnitToISO20022UnitOfMeasureDefault
    extends UnitToISO20022UnitOfMeasure {
        @Override
        protected String doEvaluate(UnitType unit) {
            String unitOfMeasure = null;
            return this.assignOutput(unitOfMeasure, unit);
        }

        protected String assignOutput(String unitOfMeasure, UnitType unit) {
            unitOfMeasure = (String)MapperS.of((Object)unit).mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.capacityUnitToISO20022UnitOfMeasure.evaluate((CapacityUnitEnum)item.map("getCapacityUnit", unitType -> unitType.getCapacityUnit()).get()));
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.weatherUnitToISO20022UnitOfMeasure.evaluate((WeatherUnitEnum)item.map("getWeatherUnit", unitType -> unitType.getWeatherUnit()).get()));
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)this.financialUnitToISO20022UnitOfMeasure.evaluate((FinancialUnitEnum)item.map("getFinancialUnit", unitType -> unitType.getFinancialUnit()).get()));
                }
                return MapperS.ofNull();
            }).get();
            return unitOfMeasure;
        }
    }
}

