/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.types;

import com.regnosys.rosetta.generator.java.types.JavaTypeUtil;
import com.rosetta.util.types.BinaryCommunicativeJavaTypeVisitor;
import com.rosetta.util.types.JavaArrayType;
import com.rosetta.util.types.JavaClass;
import com.rosetta.util.types.JavaGenericTypeDeclaration;
import com.rosetta.util.types.JavaParameterizedType;
import com.rosetta.util.types.JavaPrimitiveType;
import com.rosetta.util.types.JavaReferenceType;
import com.rosetta.util.types.JavaType;
import com.rosetta.util.types.JavaTypeArgument;
import com.rosetta.util.types.JavaTypeDeclaration;
import com.rosetta.util.types.JavaTypeVariable;
import com.rosetta.util.types.JavaWildcardTypeArgument;
import jakarta.inject.Inject;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class JavaTypeJoiner
extends BinaryCommunicativeJavaTypeVisitor<JavaType> {
    @Inject
    private JavaTypeUtil typeUtil;

    public JavaReferenceType visitTypes(JavaReferenceType left, JavaReferenceType right) {
        return (JavaReferenceType)this.visitTypes((JavaType)left, (JavaType)right);
    }

    public JavaType visitTypes(JavaArrayType left, JavaArrayType right) {
        if (left.equals((Object)right)) {
            return left;
        }
        JavaType leftBase = left.getBaseType();
        JavaType rightBase = right.getBaseType();
        if (leftBase instanceof JavaReferenceType && rightBase instanceof JavaReferenceType) {
            return new JavaArrayType((JavaType)this.visitTypes(left.getBaseType(), right.getBaseType()));
        }
        return this.typeUtil.OBJECT;
    }

    protected JavaClass<?> visitTypes(JavaArrayType left, JavaClass<?> right) {
        if (this.typeUtil.CLONEABLE.equals(right) || this.typeUtil.SERIALIZABLE.equals(right)) {
            return right;
        }
        return this.typeUtil.OBJECT;
    }

    protected JavaType visitTypes(JavaArrayType left, JavaParameterizedType<?> right) {
        return this.typeUtil.OBJECT;
    }

    protected JavaType visitTypes(JavaArrayType left, JavaPrimitiveType right) {
        return this.typeUtil.OBJECT;
    }

    protected JavaType visitTypes(JavaArrayType left, JavaTypeVariable right) {
        return this.typeUtil.OBJECT;
    }

    protected JavaArrayType visitTypeAndNull(JavaArrayType left) {
        return left;
    }

    private JavaClass<?> joinClasses(JavaClass<?> left, JavaTypeDeclaration<?> leftDecl, JavaClass<?> right, JavaTypeDeclaration<?> rightDecl) {
        if (left.equals(right)) {
            return left;
        }
        JavaTypeDeclaration<?> joinedDeclaration = this.joinTypeDeclarations(leftDecl, rightDecl);
        if (joinedDeclaration instanceof JavaGenericTypeDeclaration) {
            JavaGenericTypeDeclaration genericSuperDeclaration = (JavaGenericTypeDeclaration)joinedDeclaration;
            Map<JavaTypeVariable, JavaTypeArgument> subLeft = this.getSubstitution(genericSuperDeclaration, left);
            Map<JavaTypeVariable, JavaTypeArgument> subRight = this.getSubstitution(genericSuperDeclaration, right);
            return JavaParameterizedType.from((JavaGenericTypeDeclaration)genericSuperDeclaration, genericSuperDeclaration.getParameters().stream().map(p -> this.joinTypeArguments((JavaTypeArgument)subLeft.get(p), (JavaTypeArgument)subRight.get(p))).collect(Collectors.toList()));
        }
        return (JavaClass)joinedDeclaration;
    }

    private JavaTypeDeclaration<?> joinTypeDeclarations(JavaTypeDeclaration<?> left, JavaTypeDeclaration<?> right) {
        JavaTypeDeclaration superType = left;
        while (!right.extendsDeclaration(superType)) {
            superType = superType.getSuperclassDeclaration();
        }
        if (superType.equals(this.typeUtil.OBJECT)) {
            superType = left;
            while (!superType.equals(this.typeUtil.OBJECT)) {
                JavaTypeDeclaration interfaceJoin = (JavaTypeDeclaration)left.getInterfaceDeclarations().stream().map(i -> this.joinTypeDeclarations((JavaTypeDeclaration<?>)i, right)).filter(d -> !d.equals(this.typeUtil.OBJECT)).findFirst().orElse((JavaTypeDeclaration)this.typeUtil.OBJECT);
                if (interfaceJoin != this.typeUtil.OBJECT) {
                    return interfaceJoin;
                }
                superType = superType.getSuperclassDeclaration();
            }
        }
        return superType;
    }

    private JavaTypeArgument joinTypeArguments(JavaTypeArgument left, JavaTypeArgument right) {
        if (left.equals((Object)right)) {
            return left;
        }
        if (left == JavaReferenceType.NULL_TYPE) {
            return right;
        }
        if (right == JavaReferenceType.NULL_TYPE) {
            return left;
        }
        if (left instanceof JavaReferenceType && right instanceof JavaReferenceType) {
            JavaReferenceType join = this.visitTypes((JavaReferenceType)left, (JavaReferenceType)right);
            if (join.equals(this.typeUtil.OBJECT)) {
                return JavaWildcardTypeArgument.unbounded();
            }
            return JavaWildcardTypeArgument.extendsBound((JavaReferenceType)join);
        }
        if (left instanceof JavaReferenceType || right instanceof JavaReferenceType) {
            JavaWildcardTypeArgument wildcardType;
            JavaReferenceType refType;
            if (left instanceof JavaReferenceType) {
                refType = (JavaReferenceType)left;
                wildcardType = (JavaWildcardTypeArgument)right;
            } else {
                refType = (JavaReferenceType)right;
                wildcardType = (JavaWildcardTypeArgument)left;
            }
            if (wildcardType.isUnbounded()) {
                return wildcardType;
            }
            JavaReferenceType bound = (JavaReferenceType)wildcardType.getBound().orElseThrow();
            if (wildcardType.hasExtendsBound()) {
                JavaReferenceType join = this.visitTypes(refType, bound);
                if (join.equals(this.typeUtil.OBJECT)) {
                    return JavaWildcardTypeArgument.unbounded();
                }
                return JavaWildcardTypeArgument.extendsBound((JavaReferenceType)join);
            }
            if (bound.isSubtypeOf((JavaType)refType)) {
                return bound;
            }
            if (refType.isSubtypeOf((JavaType)bound) && !refType.equals(this.typeUtil.OBJECT)) {
                return JavaWildcardTypeArgument.superBound((JavaReferenceType)refType);
            }
            return JavaWildcardTypeArgument.unbounded();
        }
        JavaWildcardTypeArgument leftWildcard = (JavaWildcardTypeArgument)left;
        JavaWildcardTypeArgument rightWildcard = (JavaWildcardTypeArgument)right;
        if (leftWildcard.isUnbounded()) {
            return leftWildcard;
        }
        if (rightWildcard.isUnbounded()) {
            return rightWildcard;
        }
        JavaReferenceType leftBound = (JavaReferenceType)leftWildcard.getBound().orElseThrow();
        JavaReferenceType rightBound = (JavaReferenceType)rightWildcard.getBound().orElseThrow();
        if (leftWildcard.hasExtendsBound()) {
            if (rightWildcard.hasSuperBound()) {
                return JavaWildcardTypeArgument.unbounded();
            }
            JavaReferenceType join = this.visitTypes(leftBound, rightBound);
            if (join.equals(this.typeUtil.OBJECT)) {
                return JavaWildcardTypeArgument.unbounded();
            }
            return JavaWildcardTypeArgument.extendsBound((JavaReferenceType)join);
        }
        if (rightWildcard.hasExtendsBound()) {
            return JavaWildcardTypeArgument.unbounded();
        }
        if (leftBound.isSubtypeOf((JavaType)rightBound)) {
            return leftWildcard;
        }
        if (rightBound.isSubtypeOf((JavaType)leftBound)) {
            return rightWildcard;
        }
        return JavaWildcardTypeArgument.unbounded();
    }

    private Map<JavaTypeVariable, JavaTypeArgument> getSubstitution(JavaGenericTypeDeclaration<?> d, JavaClass<?> c) {
        JavaClass currentSuper = c;
        JavaClass nextSuper = currentSuper.getSuperclass();
        while (nextSuper.extendsDeclaration(d)) {
            currentSuper = nextSuper;
            nextSuper = nextSuper.getSuperclass();
        }
        Optional<JavaClass> nextInterface = currentSuper.getInterfaces().stream().filter(i -> i.extendsDeclaration((JavaTypeDeclaration)d)).findAny();
        while (nextInterface.isPresent()) {
            currentSuper = nextInterface.orElseThrow();
            nextInterface = currentSuper.getInterfaces().stream().filter(i -> i.extendsDeclaration((JavaTypeDeclaration)d)).findAny();
        }
        return ((JavaParameterizedType)currentSuper).getTypeVariableSubstitution();
    }

    protected JavaClass<?> visitTypes(JavaClass<?> left, JavaClass<?> right) {
        return this.joinClasses(left, (JavaTypeDeclaration<?>)left, right, (JavaTypeDeclaration<?>)right);
    }

    protected JavaClass<?> visitTypes(JavaClass<?> left, JavaParameterizedType<?> right) {
        return this.joinClasses(left, (JavaTypeDeclaration<?>)left, (JavaClass<?>)right, (JavaTypeDeclaration<?>)right.getGenericTypeDeclaration());
    }

    protected JavaType visitTypes(JavaClass<?> left, JavaPrimitiveType right) {
        return this.visitTypes(left, (JavaClass<?>)right.toReferenceType());
    }

    protected JavaReferenceType visitTypes(JavaClass<?> left, JavaTypeVariable right) {
        return (JavaReferenceType)right.getBounds().stream().map(b -> this.visitTypes((JavaReferenceType)left, (JavaReferenceType)b)).filter(j -> !j.equals(this.typeUtil.OBJECT)).findAny().orElse((JavaReferenceType)this.typeUtil.OBJECT);
    }

    protected JavaClass<?> visitTypeAndNull(JavaClass<?> left) {
        return left;
    }

    protected JavaClass<?> visitTypes(JavaParameterizedType<?> left, JavaParameterizedType<?> right) {
        return this.joinClasses((JavaClass<?>)left, (JavaTypeDeclaration<?>)left.getGenericTypeDeclaration(), (JavaClass<?>)right, (JavaTypeDeclaration<?>)right.getGenericTypeDeclaration());
    }

    protected JavaType visitTypes(JavaParameterizedType<?> left, JavaPrimitiveType right) {
        return this.visitTypes((JavaClass<?>)left, (JavaClass<?>)right.toReferenceType());
    }

    protected JavaType visitTypes(JavaParameterizedType<?> left, JavaTypeVariable right) {
        return (JavaType)right.getBounds().stream().map(b -> this.visitTypes((JavaReferenceType)left, (JavaReferenceType)b)).filter(j -> !j.equals(this.typeUtil.OBJECT)).findAny().orElse((JavaReferenceType)this.typeUtil.OBJECT);
    }

    protected JavaParameterizedType<?> visitTypeAndNull(JavaParameterizedType<?> left) {
        return left;
    }

    protected JavaType visitTypes(JavaPrimitiveType left, JavaPrimitiveType right) {
        if (left.isSubtypeOf((JavaType)right)) {
            return right;
        }
        if (right.isSubtypeOf((JavaType)left)) {
            return left;
        }
        if (left.equals((Object)JavaPrimitiveType.CHAR) && right.isSubtypeOf((JavaType)JavaPrimitiveType.INT) || right.equals((Object)JavaPrimitiveType.CHAR) && left.isSubtypeOf((JavaType)JavaPrimitiveType.INT)) {
            return JavaPrimitiveType.INT;
        }
        return this.typeUtil.OBJECT;
    }

    protected JavaReferenceType visitTypes(JavaPrimitiveType left, JavaTypeVariable right) {
        return this.visitTypes((JavaClass<?>)left.toReferenceType(), right);
    }

    protected JavaClass<?> visitTypeAndNull(JavaPrimitiveType left) {
        return left.toReferenceType();
    }

    protected JavaReferenceType visitTypes(JavaTypeVariable left, JavaTypeVariable right) {
        if (left.equals((Object)right)) {
            return left;
        }
        return (JavaReferenceType)left.getBounds().stream().flatMap(lb -> right.getBounds().stream().map(rb -> this.visitTypes((JavaReferenceType)lb, (JavaReferenceType)rb))).filter(j -> !j.equals(this.typeUtil.OBJECT)).findAny().orElse((JavaReferenceType)this.typeUtil.OBJECT);
    }

    protected JavaTypeVariable visitTypeAndNull(JavaTypeVariable left) {
        return left;
    }

    protected JavaReferenceType visitBothNull() {
        return JavaReferenceType.NULL_TYPE;
    }
}

