/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.generator.java.util;

import com.google.common.base.Strings;
import com.regnosys.rosetta.rosetta.RosettaFeature;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.ILeafNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

public class RosettaGrammarUtil {
    public static String quote(String text) {
        String _replace = text.trim().replace("\"", "\\\"").replace("\r\n", "\n").replace("\n\n", "\n").replace("\n", "\\n\" + \n\t\"");
        String _plus = "\"" + _replace;
        return _plus + "\"";
    }

    public static String grammarText(EObject expr) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)expr);
        if (node == null) {
            return "";
        }
        if (node instanceof ILeafNode) {
            return node.getText();
        }
        Functions.Function1 _function = it -> Strings.nullToEmpty((String)it.getText());
        return IterableExtensions.join((Iterable)IterableExtensions.map((Iterable)node.getLeafNodes(), (Functions.Function1)_function));
    }

    public static String grammarWhenThen(EObject when, EObject then) {
        String _trim = RosettaGrammarUtil.grammarText(when).trim();
        String _plus = "when " + _trim;
        String _plus_1 = _plus + "\nthen ";
        String _trim_1 = RosettaGrammarUtil.grammarText(then).trim();
        return _plus_1 + _trim_1;
    }

    public static String extractNodeText(EObject rosettaFeature, EStructuralFeature feature) {
        Functions.Function1 _function = it -> NodeModelUtils.getTokenText((INode)it);
        return IterableExtensions.join((Iterable)ListExtensions.map((List)NodeModelUtils.findNodesForFeature((EObject)rosettaFeature, (EStructuralFeature)feature), (Functions.Function1)_function));
    }

    public static String extractGrammarText(RosettaFeature rosettaFeature) {
        ICompositeNode node = NodeModelUtils.getNode((EObject)rosettaFeature);
        if (node == null) {
            return null;
        }
        if (node instanceof ILeafNode) {
            return node.getText();
        }
        int _max = Math.max(node.getTotalLength(), 1);
        StringBuilder builder = new StringBuilder(_max);
        Iterable _leafNodes = node.getLeafNodes();
        for (ILeafNode leaf : _leafNodes) {
            builder.append(leaf.getText());
        }
        return builder.toString().trim().replace("\n", "\\n").replace("\r", "");
    }
}

