/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.types;

import com.regnosys.rosetta.utils.PositiveIntegerInterval;
import java.util.Objects;
import java.util.Optional;

public class RCardinality {
    public static RCardinality SINGLE = RCardinality.bounded(1, 1);
    public static RCardinality OPTIONAL = RCardinality.bounded(0, 1);
    public static RCardinality UNBOUNDED = RCardinality.unbounded(0);
    private final PositiveIntegerInterval interval;

    private RCardinality(PositiveIntegerInterval interval) {
        this.interval = interval;
    }

    public static RCardinality bounded(final int min, final int max) {
        if (max < min) {
            return new RCardinality(null){

                @Override
                public int getMin() {
                    return min;
                }

                @Override
                public boolean isMulti() {
                    return max > 1;
                }

                @Override
                public boolean isOptional() {
                    return min == 0;
                }

                @Override
                public boolean includes(int x) {
                    return false;
                }

                @Override
                public boolean includes(RCardinality other) {
                    return false;
                }

                @Override
                public String toString() {
                    StringBuilder builder = new StringBuilder();
                    builder.append('(');
                    builder.append(min);
                    builder.append("..");
                    builder.append(max);
                    builder.append(')');
                    return builder.toString();
                }
            };
        }
        return new RCardinality(PositiveIntegerInterval.bounded(min, max));
    }

    public static RCardinality unbounded(int min) {
        return new RCardinality(PositiveIntegerInterval.boundedLeft(min));
    }

    public int getMin() {
        return this.interval.getMinBound();
    }

    public Optional<Integer> getMax() {
        return this.interval.getMax();
    }

    public boolean isMulti() {
        return this.interval.getMax().map(m -> m > 1).orElse(true);
    }

    public boolean isOptional() {
        return this.interval.getMinBound() == 0;
    }

    public boolean includes(int x) {
        return this.interval.includes(x);
    }

    public boolean includes(RCardinality other) {
        return this.interval.includes(other.interval);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        builder.append(this.interval.getMinBound());
        builder.append("..");
        this.interval.getMax().ifPresentOrElse(b -> builder.append(b), () -> builder.append('*'));
        builder.append(')');
        return builder.toString();
    }

    public int hashCode() {
        return Objects.hash(this.interval);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RCardinality other = (RCardinality)obj;
        return Objects.equals(this.interval, other.interval);
    }
}

