/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.merging;

import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.util.CollectionUtils;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;

public class SimpleMerger
implements BuilderMerger {
    private final Consumer<RosettaModelObjectBuilder> postProcessor;

    public SimpleMerger() {
        this(null);
    }

    public SimpleMerger(Consumer<RosettaModelObjectBuilder> postProcessor) {
        this.postProcessor = postProcessor;
    }

    public <T extends RosettaModelObjectBuilder> void run(T o1, T o2) {
        RosettaModelObjectBuilder merged = Objects.requireNonNull(o1).merge(Objects.requireNonNull(o2), (BuilderMerger)this).prune();
        Optional.ofNullable(this.postProcessor).ifPresent(p -> p.accept(merged));
    }

    public <T extends RosettaModelObjectBuilder> void mergeRosetta(T o1, T o2, Consumer<T> o1Setter) {
        if (o1 != null && o2 != null) {
            o1.merge(o2, (BuilderMerger)this);
        } else {
            Optional.ofNullable(o2).ifPresent(o1Setter);
        }
    }

    public <T extends RosettaModelObjectBuilder> void mergeRosetta(List<? extends T> o1, List<? extends T> o2, Function<Integer, T> o1GetOrCreateByIndex) {
        int i = 0;
        Iterator i2 = CollectionUtils.emptyIfNull(o2).iterator();
        while (i2.hasNext()) {
            if (i2.hasNext()) {
                ((RosettaModelObjectBuilder)o1GetOrCreateByIndex.apply(i)).merge((RosettaModelObjectBuilder)i2.next(), (BuilderMerger)this);
            }
            ++i;
        }
    }

    public <T> void mergeBasic(T o1, T o2, Consumer<T> o1Setter, AttributeMeta ... metas) {
        if (o1 != null && o2 != null && !o1.equals(o2)) {
            if (!this.metaContains(metas, AttributeMeta.GLOBAL_KEY)) {
                throw new IllegalArgumentException(String.format("Attempting to merge 2 different basic values [o1=%s, o2=%s, type=%s]", o1, o2, o1.getClass().getSimpleName()));
            }
        } else {
            Optional.ofNullable(o2).ifPresent(o1Setter);
        }
    }

    public <T> void mergeBasic(List<? extends T> o1, List<? extends T> o2, Consumer<T> o1Add) {
        CollectionUtils.emptyIfNull(o2).forEach(o1Add);
    }

    private boolean metaContains(AttributeMeta[] metas, AttributeMeta attributeMeta) {
        return Arrays.stream(metas).anyMatch(m -> m == attributeMeta);
    }
}

