/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.postprocess.qualify;

import com.rosetta.model.lib.qualify.QualifyResult;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public class QualificationResult {
    private final Class<?> qualifiedRosettaObjectType;
    private final List<QualifyResult> allQualifyResults;

    public QualificationResult(Class<?> qualifiedRosettaObjectType, List<QualifyResult> allQualifyResults) {
        this.qualifiedRosettaObjectType = qualifiedRosettaObjectType;
        this.allQualifyResults = allQualifyResults;
    }

    public Class<?> getQualifiedRosettaObjectType() {
        return this.qualifiedRosettaObjectType;
    }

    public Optional<QualifyResult> getUniqueSuccessQualifyResult() {
        return this.getSucessQualificationResults().size() == 1 ? Optional.of(this.getSucessQualificationResults().get(0)) : Optional.empty();
    }

    public boolean isSuccess() {
        return this.getUniqueSuccessQualifyResult().isPresent();
    }

    public List<QualifyResult> getAllQualifyResults() {
        return this.allQualifyResults;
    }

    public String toString() {
        if (this.getUniqueSuccessQualifyResult().isPresent()) {
            return String.format("QualificationResult { SUCCESS on [%s:%s] }", this.qualifiedRosettaObjectType.getSimpleName(), this.getUniqueSuccessQualifyResult().get().getName());
        }
        List successResults = this.getSucessQualificationResults().stream().map(QualifyResult::getName).collect(Collectors.toList());
        List errors = this.allQualifyResults.stream().filter(r -> !r.isSuccess()).map(this::getQualifyFunctionErrors).collect(Collectors.toList());
        return String.format("QualificationResult { FAILURE on [%s] because [%s]%s }", this.qualifiedRosettaObjectType.getSimpleName(), successResults.isEmpty() ? "UNMATCHED" : "MULTIPLE_MATCHES: " + String.join((CharSequence)",", successResults), successResults.isEmpty() ? String.format(", errors: [%s]", errors) : "");
    }

    private List<QualifyResult> getSucessQualificationResults() {
        return this.allQualifyResults.stream().filter(QualifyResult::isSuccess).collect(Collectors.toList());
    }

    private String getQualifyFunctionErrors(QualifyResult qualifyFunctionResult) {
        List failedFunctionErrors = qualifyFunctionResult.getExpressionDataRuleResults().stream().filter(e -> !e.isSuccess()).map(QualifyResult.ExpressionDataRuleResult::getError).collect(Collectors.toList());
        return String.format("%s%s", qualifyFunctionResult.getName(), failedFunctionErrors);
    }
}

