/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.common.util;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.function.BiPredicate;

public class CollectionUtils {
    public static <A> boolean listMatch(List<A> list1, List<A> list2, BiPredicate<A, A> comparer) {
        if (list1.size() != list2.size()) {
            return false;
        }
        Iterator<A> it1 = list1.iterator();
        for (A a2 : list2) {
            A a1 = it1.next();
            if (comparer.test(a1, a2)) continue;
            return false;
        }
        return true;
    }

    public static <A> boolean collectionContains(Collection<A> col1, Collection<A> col2, BiPredicate<A, A> comparer) {
        LinkedList<A> tempCol = new LinkedList<A>(col2);
        for (A a1 : col1) {
            Iterator it = tempCol.iterator();
            boolean found = false;
            while (!found && it.hasNext()) {
                Object a2 = it.next();
                if (!comparer.test(a1, a2)) continue;
                found = true;
                it.remove();
            }
            if (found) continue;
            return false;
        }
        return true;
    }
}

