/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect;

import com.google.common.math.DoubleMath;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;

public final class DoubleArrayMath {
    public static final double[] EMPTY_DOUBLE_ARRAY = new double[0];
    public static final Double[] EMPTY_DOUBLE_OBJECT_ARRAY = new Double[0];

    private DoubleArrayMath() {
    }

    public static Double[] toObject(double[] array) {
        if (array.length == 0) {
            return EMPTY_DOUBLE_OBJECT_ARRAY;
        }
        Double[] result = new Double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double[] toPrimitive(Double[] array) {
        if (array.length == 0) {
            return EMPTY_DOUBLE_ARRAY;
        }
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i];
        }
        return result;
    }

    public static double sum(double[] array) {
        double total = 0.0;
        for (int i = 0; i < array.length; ++i) {
            total += array[i];
        }
        return total;
    }

    public static double[] applyAddition(double[] array, double valueToAdd) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] + valueToAdd;
        }
        return result;
    }

    public static double[] applyMultiplication(double[] array, double valueToMultiplyBy) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = array[i] * valueToMultiplyBy;
        }
        return result;
    }

    public static double[] apply(double[] array, DoubleUnaryOperator operator) {
        double[] result = new double[array.length];
        for (int i = 0; i < array.length; ++i) {
            result[i] = operator.applyAsDouble(array[i]);
        }
        return result;
    }

    public static void mutateByAddition(double[] array, double valueToAdd) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] + valueToAdd;
        }
    }

    public static void mutateByAddition(double[] array, double[] arrayToAdd) {
        int length = DoubleArrayMath.length(array, arrayToAdd);
        for (int i = 0; i < length; ++i) {
            int n = i;
            array[n] = array[n] + arrayToAdd[i];
        }
    }

    public static void mutateByMultiplication(double[] array, double valueToMultiplyBy) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] * valueToMultiplyBy;
        }
    }

    public static void mutateByMultiplication(double[] array, double[] arrayToMultiplyBy) {
        int length = DoubleArrayMath.length(array, arrayToMultiplyBy);
        for (int i = 0; i < length; ++i) {
            int n = i;
            array[n] = array[n] * arrayToMultiplyBy[i];
        }
    }

    public static void mutate(double[] array, DoubleUnaryOperator operator) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = operator.applyAsDouble(array[i]);
        }
    }

    public static double[] combineByAddition(double[] array1, double[] array2) {
        return DoubleArrayMath.combine(array1, array2, (a, b) -> a + b);
    }

    public static double[] combineByMultiplication(double[] array1, double[] array2) {
        return DoubleArrayMath.combine(array1, array2, (a, b) -> a * b);
    }

    public static double[] combine(double[] array1, double[] array2, DoubleBinaryOperator operator) {
        int length = DoubleArrayMath.length(array1, array2);
        double[] result = new double[length];
        for (int i = 0; i < length; ++i) {
            result[i] = operator.applyAsDouble(array1[i], array2[i]);
        }
        return result;
    }

    public static double[] combineLenient(double[] array1, double[] array2, DoubleBinaryOperator operator) {
        int len1 = array1.length;
        int len2 = array2.length;
        if (len1 == len2) {
            return DoubleArrayMath.combine(array1, array2, operator);
        }
        int size = Math.max(len1, len2);
        double[] result = new double[size];
        for (int i = 0; i < size; ++i) {
            if (i < len1) {
                if (i < len2) {
                    result[i] = operator.applyAsDouble(array1[i], array2[i]);
                    continue;
                }
                result[i] = array1[i];
                continue;
            }
            result[i] = array2[i];
        }
        return result;
    }

    public static boolean fuzzyEqualsZero(double[] array, double tolerance) {
        for (int i = 0; i < array.length; ++i) {
            if (DoubleMath.fuzzyEquals((double)array[i], (double)0.0, (double)tolerance)) continue;
            return false;
        }
        return true;
    }

    public static boolean fuzzyEquals(double[] array1, double[] array2, double tolerance) {
        if (array1.length != array2.length) {
            return false;
        }
        for (int i = 0; i < array1.length; ++i) {
            if (DoubleMath.fuzzyEquals((double)array1[i], (double)array2[i], (double)tolerance)) continue;
            return false;
        }
        return true;
    }

    public static void sortPairs(double[] keys, double[] values) {
        int len1 = keys.length;
        if (len1 != values.length) {
            throw new IllegalArgumentException("Arrays cannot be sorted as they differ in length");
        }
        DoubleArrayMath.dualArrayQuickSort(keys, values, 0, len1 - 1);
    }

    private static void dualArrayQuickSort(double[] keys, double[] values, int left, int right) {
        if (right > left) {
            int pivot = left + right >> 1;
            int pivotNewIndex = DoubleArrayMath.partition(keys, values, left, right, pivot);
            DoubleArrayMath.dualArrayQuickSort(keys, values, left, pivotNewIndex - 1);
            DoubleArrayMath.dualArrayQuickSort(keys, values, pivotNewIndex + 1, right);
        }
    }

    private static int partition(double[] keys, double[] values, int left, int right, int pivot) {
        double pivotValue = keys[pivot];
        DoubleArrayMath.swap(keys, values, pivot, right);
        int storeIndex = left;
        for (int i = left; i < right; ++i) {
            if (!(keys[i] <= pivotValue)) continue;
            DoubleArrayMath.swap(keys, values, i, storeIndex);
            ++storeIndex;
        }
        DoubleArrayMath.swap(keys, values, storeIndex, right);
        return storeIndex;
    }

    private static void swap(double[] keys, double[] values, int first, int second) {
        double t = keys[first];
        keys[first] = keys[second];
        keys[second] = t;
        t = values[first];
        values[first] = values[second];
        values[second] = t;
    }

    public static <V> void sortPairs(double[] keys, V[] values) {
        int len1 = keys.length;
        if (len1 != values.length) {
            throw new IllegalArgumentException("Arrays cannot be sorted as they differ in length");
        }
        DoubleArrayMath.dualArrayQuickSort(keys, values, 0, len1 - 1);
    }

    private static <T> void dualArrayQuickSort(double[] keys, T[] values, int left, int right) {
        if (right > left) {
            int pivot = left + right >> 1;
            int pivotNewIndex = DoubleArrayMath.partition(keys, values, left, right, pivot);
            DoubleArrayMath.dualArrayQuickSort(keys, values, left, pivotNewIndex - 1);
            DoubleArrayMath.dualArrayQuickSort(keys, values, pivotNewIndex + 1, right);
        }
    }

    private static <T> int partition(double[] keys, T[] values, int left, int right, int pivot) {
        double pivotValue = keys[pivot];
        DoubleArrayMath.swap(keys, values, pivot, right);
        int storeIndex = left;
        for (int i = left; i < right; ++i) {
            if (!(keys[i] <= pivotValue)) continue;
            DoubleArrayMath.swap(keys, values, i, storeIndex);
            ++storeIndex;
        }
        DoubleArrayMath.swap(keys, values, storeIndex, right);
        return storeIndex;
    }

    private static <T> void swap(double[] keys, T[] values, int first, int second) {
        double x = keys[first];
        keys[first] = keys[second];
        keys[second] = x;
        T t = values[first];
        values[first] = values[second];
        values[second] = t;
    }

    private static int length(double[] array1, double[] array2) {
        int len1 = array1.length;
        int len2 = array2.length;
        if (len1 != len2) {
            throw new IllegalArgumentException("Arrays cannot be combined as they differ in length");
        }
        return len1;
    }
}

