/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.collect.tuple;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.tuple.Pair;
import com.opengamma.strata.collect.tuple.Tuple;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

@BeanDefinition(builderScope="private")
public final class LongDoublePair
implements ImmutableBean,
Tuple,
Comparable<LongDoublePair>,
Serializable {
    @PropertyDefinition
    private final long first;
    @PropertyDefinition
    private final double second;
    private static final long serialVersionUID = 1L;

    public static LongDoublePair of(long first, double second) {
        return new LongDoublePair(first, second);
    }

    public static LongDoublePair ofPair(Pair<Long, Double> pair) {
        ArgChecker.notNull(pair, "pair");
        return new LongDoublePair(pair.getFirst(), pair.getSecond());
    }

    @FromString
    public static LongDoublePair parse(String pairStr) {
        ArgChecker.notNull(pairStr, "pairStr");
        if (pairStr.length() < 5) {
            throw new IllegalArgumentException("Invalid pair format, too short: " + pairStr);
        }
        if (pairStr.charAt(0) != '[') {
            throw new IllegalArgumentException("Invalid pair format, must start with [: " + pairStr);
        }
        if (pairStr.charAt(pairStr.length() - 1) != ']') {
            throw new IllegalArgumentException("Invalid pair format, must end with ]: " + pairStr);
        }
        String content = pairStr.substring(1, pairStr.length() - 1);
        List split = Splitter.on((char)',').trimResults().splitToList((CharSequence)content);
        if (split.size() != 2) {
            throw new IllegalArgumentException("Invalid pair format, must have two values: " + pairStr);
        }
        long first = Long.parseLong((String)split.get(0));
        double second = Double.parseDouble((String)split.get(1));
        return new LongDoublePair(first, second);
    }

    @Override
    public int size() {
        return 2;
    }

    public ImmutableList<Object> elements() {
        return ImmutableList.of((Object)this.first, (Object)this.second);
    }

    public Pair<Long, Double> toPair() {
        return Pair.of(this.first, this.second);
    }

    @Override
    public int compareTo(LongDoublePair other) {
        int cmp = Long.compare(this.first, other.first);
        if (cmp == 0) {
            cmp = Double.compare(this.second, other.second);
        }
        return cmp;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof LongDoublePair) {
            LongDoublePair other = (LongDoublePair)obj;
            return this.first == other.first && JodaBeanUtils.equal((double)this.second, (double)other.second);
        }
        return super.equals(obj);
    }

    public int hashCode() {
        long s = Double.doubleToLongBits(this.second);
        return (int)(this.first ^ this.first >>> 32) ^ (int)(s ^ s >>> 32);
    }

    @ToString
    public String toString() {
        return "" + '[' + this.first + ", " + this.second + ']';
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private LongDoublePair(long first, double second) {
        this.first = first;
        this.second = second;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public long getFirst() {
        return this.first;
    }

    public double getSecond() {
        return this.second;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<LongDoublePair> {
        private long first;
        private double second;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return this.first;
                }
                case -906279820: {
                    return this.second;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    this.first = (Long)newValue;
                    break;
                }
                case -906279820: {
                    this.second = (Double)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public LongDoublePair build() {
            return new LongDoublePair(this.first, this.second);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("LongDoublePair.Builder{");
            buf.append("first").append('=').append(JodaBeanUtils.toString((Object)this.first)).append(',').append(' ');
            buf.append("second").append('=').append(JodaBeanUtils.toString((Object)this.second));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<Long> first = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"first", LongDoublePair.class, Long.TYPE);
        private final MetaProperty<Double> second = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"second", LongDoublePair.class, Double.TYPE);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"first", "second"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return this.first;
                }
                case -906279820: {
                    return this.second;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends LongDoublePair> builder() {
            return new Builder();
        }

        public Class<? extends LongDoublePair> beanType() {
            return LongDoublePair.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<Long> first() {
            return this.first;
        }

        public MetaProperty<Double> second() {
            return this.second;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 97440432: {
                    return ((LongDoublePair)bean).getFirst();
                }
                case -906279820: {
                    return ((LongDoublePair)bean).getSecond();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

