/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.event.common.TradeState;
import cdm.event.common.Transfer;
import cdm.event.common.meta.BillingRecordMeta;
import cdm.event.common.metafields.ReferenceWithMetaTradeState;
import cdm.observable.asset.Money;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="BillingRecord", builder=BillingRecordBuilderImpl.class, version="5.30.0")
@RuneDataType(value="BillingRecord", model="cdm", builder=BillingRecordBuilderImpl.class, version="5.30.0")
public interface BillingRecord
extends RosettaModelObject {
    public static final BillingRecordMeta metaData = new BillingRecordMeta();

    public ReferenceWithMetaTradeState getTradeState();

    public Transfer getRecordTransfer();

    public Date getRecordStartDate();

    public Date getRecordEndDate();

    public Money getMinimumFee();

    public BillingRecord build();

    public BillingRecordBuilder toBuilder();

    public static BillingRecordBuilder builder() {
        return new BillingRecordBuilderImpl();
    }

    default public RosettaMetaData<? extends BillingRecord> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends BillingRecord> getType() {
        return BillingRecord.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("tradeState"), processor, ReferenceWithMetaTradeState.class, this.getTradeState(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("recordTransfer"), processor, Transfer.class, this.getRecordTransfer(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("recordStartDate"), Date.class, (Object)this.getRecordStartDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("recordEndDate"), Date.class, (Object)this.getRecordEndDate(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("minimumFee"), processor, Money.class, this.getMinimumFee(), new AttributeMeta[0]);
    }

    public static class BillingRecordBuilderImpl
    implements BillingRecordBuilder {
        protected ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder tradeState;
        protected Transfer.TransferBuilder recordTransfer;
        protected Date recordStartDate;
        protected Date recordEndDate;
        protected Money.MoneyBuilder minimumFee;

        @Override
        @RosettaAttribute(value="tradeState", isRequired=true)
        @RuneAttribute(value="tradeState", isRequired=true)
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeState() {
            return this.tradeState;
        }

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeState() {
            ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder result = this.tradeState != null ? this.tradeState : (this.tradeState = ReferenceWithMetaTradeState.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="recordTransfer", isRequired=true)
        @RuneAttribute(value="recordTransfer", isRequired=true)
        public Transfer.TransferBuilder getRecordTransfer() {
            return this.recordTransfer;
        }

        @Override
        public Transfer.TransferBuilder getOrCreateRecordTransfer() {
            Transfer.TransferBuilder result = this.recordTransfer != null ? this.recordTransfer : (this.recordTransfer = Transfer.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="recordStartDate", isRequired=true)
        @RuneAttribute(value="recordStartDate", isRequired=true)
        public Date getRecordStartDate() {
            return this.recordStartDate;
        }

        @Override
        @RosettaAttribute(value="recordEndDate", isRequired=true)
        @RuneAttribute(value="recordEndDate", isRequired=true)
        public Date getRecordEndDate() {
            return this.recordEndDate;
        }

        @Override
        @RosettaAttribute(value="minimumFee")
        @RuneAttribute(value="minimumFee")
        public Money.MoneyBuilder getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        public Money.MoneyBuilder getOrCreateMinimumFee() {
            Money.MoneyBuilder result = this.minimumFee != null ? this.minimumFee : (this.minimumFee = Money.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="tradeState", isRequired=true)
        @RuneAttribute(value="tradeState", isRequired=true)
        public BillingRecordBuilder setTradeState(ReferenceWithMetaTradeState _tradeState) {
            this.tradeState = _tradeState == null ? null : _tradeState.toBuilder();
            return this;
        }

        @Override
        public BillingRecordBuilder setTradeStateValue(TradeState _tradeState) {
            this.getOrCreateTradeState().setValue(_tradeState);
            return this;
        }

        @Override
        @RosettaAttribute(value="recordTransfer", isRequired=true)
        @RuneAttribute(value="recordTransfer", isRequired=true)
        public BillingRecordBuilder setRecordTransfer(Transfer _recordTransfer) {
            this.recordTransfer = _recordTransfer == null ? null : _recordTransfer.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="recordStartDate", isRequired=true)
        @RuneAttribute(value="recordStartDate", isRequired=true)
        public BillingRecordBuilder setRecordStartDate(Date _recordStartDate) {
            this.recordStartDate = _recordStartDate == null ? null : _recordStartDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="recordEndDate", isRequired=true)
        @RuneAttribute(value="recordEndDate", isRequired=true)
        public BillingRecordBuilder setRecordEndDate(Date _recordEndDate) {
            this.recordEndDate = _recordEndDate == null ? null : _recordEndDate;
            return this;
        }

        @Override
        @RosettaAttribute(value="minimumFee")
        @RuneAttribute(value="minimumFee")
        public BillingRecordBuilder setMinimumFee(Money _minimumFee) {
            this.minimumFee = _minimumFee == null ? null : _minimumFee.toBuilder();
            return this;
        }

        @Override
        public BillingRecord build() {
            return new BillingRecordImpl(this);
        }

        @Override
        public BillingRecordBuilder toBuilder() {
            return this;
        }

        @Override
        public BillingRecordBuilder prune() {
            if (this.tradeState != null && !this.tradeState.prune().hasData()) {
                this.tradeState = null;
            }
            if (this.recordTransfer != null && !this.recordTransfer.prune().hasData()) {
                this.recordTransfer = null;
            }
            if (this.minimumFee != null && !this.minimumFee.prune().hasData()) {
                this.minimumFee = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getTradeState() != null && this.getTradeState().hasData()) {
                return true;
            }
            if (this.getRecordTransfer() != null && this.getRecordTransfer().hasData()) {
                return true;
            }
            if (this.getRecordStartDate() != null) {
                return true;
            }
            if (this.getRecordEndDate() != null) {
                return true;
            }
            return this.getMinimumFee() != null && this.getMinimumFee().hasData();
        }

        public BillingRecordBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            BillingRecordBuilder o = (BillingRecordBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getTradeState(), (RosettaModelObjectBuilder)o.getTradeState(), this::setTradeState);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getRecordTransfer(), (RosettaModelObjectBuilder)o.getRecordTransfer(), this::setRecordTransfer);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getMinimumFee(), (RosettaModelObjectBuilder)o.getMinimumFee(), this::setMinimumFee);
            merger.mergeBasic((Object)this.getRecordStartDate(), (Object)o.getRecordStartDate(), this::setRecordStartDate, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRecordEndDate(), (Object)o.getRecordEndDate(), this::setRecordEndDate, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BillingRecord _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeState, _that.getTradeState())) {
                return false;
            }
            if (!Objects.equals(this.recordTransfer, _that.getRecordTransfer())) {
                return false;
            }
            if (!Objects.equals(this.recordStartDate, _that.getRecordStartDate())) {
                return false;
            }
            if (!Objects.equals(this.recordEndDate, _that.getRecordEndDate())) {
                return false;
            }
            return Objects.equals(this.minimumFee, _that.getMinimumFee());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeState != null ? this.tradeState.hashCode() : 0);
            _result = 31 * _result + (this.recordTransfer != null ? this.recordTransfer.hashCode() : 0);
            _result = 31 * _result + (this.recordStartDate != null ? this.recordStartDate.hashCode() : 0);
            _result = 31 * _result + (this.recordEndDate != null ? this.recordEndDate.hashCode() : 0);
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BillingRecordBuilder {tradeState=" + this.tradeState + ", recordTransfer=" + this.recordTransfer + ", recordStartDate=" + this.recordStartDate + ", recordEndDate=" + this.recordEndDate + ", minimumFee=" + this.minimumFee + '}';
        }
    }

    public static interface BillingRecordBuilder
    extends BillingRecord,
    RosettaModelObjectBuilder {
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getOrCreateTradeState();

        @Override
        public ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder getTradeState();

        public Transfer.TransferBuilder getOrCreateRecordTransfer();

        @Override
        public Transfer.TransferBuilder getRecordTransfer();

        public Money.MoneyBuilder getOrCreateMinimumFee();

        @Override
        public Money.MoneyBuilder getMinimumFee();

        public BillingRecordBuilder setTradeState(ReferenceWithMetaTradeState var1);

        public BillingRecordBuilder setTradeStateValue(TradeState var1);

        public BillingRecordBuilder setRecordTransfer(Transfer var1);

        public BillingRecordBuilder setRecordStartDate(Date var1);

        public BillingRecordBuilder setRecordEndDate(Date var1);

        public BillingRecordBuilder setMinimumFee(Money var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("tradeState"), processor, ReferenceWithMetaTradeState.ReferenceWithMetaTradeStateBuilder.class, this.getTradeState(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("recordTransfer"), processor, Transfer.TransferBuilder.class, this.getRecordTransfer(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("recordStartDate"), Date.class, (Object)this.getRecordStartDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("recordEndDate"), Date.class, (Object)this.getRecordEndDate(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("minimumFee"), processor, Money.MoneyBuilder.class, this.getMinimumFee(), new AttributeMeta[0]);
        }

        public BillingRecordBuilder prune();
    }

    public static class BillingRecordImpl
    implements BillingRecord {
        private final ReferenceWithMetaTradeState tradeState;
        private final Transfer recordTransfer;
        private final Date recordStartDate;
        private final Date recordEndDate;
        private final Money minimumFee;

        protected BillingRecordImpl(BillingRecordBuilder builder) {
            this.tradeState = Optional.ofNullable(builder.getTradeState()).map(f -> f.build()).orElse(null);
            this.recordTransfer = Optional.ofNullable(builder.getRecordTransfer()).map(f -> f.build()).orElse(null);
            this.recordStartDate = builder.getRecordStartDate();
            this.recordEndDate = builder.getRecordEndDate();
            this.minimumFee = Optional.ofNullable(builder.getMinimumFee()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="tradeState", isRequired=true)
        @RuneAttribute(value="tradeState", isRequired=true)
        public ReferenceWithMetaTradeState getTradeState() {
            return this.tradeState;
        }

        @Override
        @RosettaAttribute(value="recordTransfer", isRequired=true)
        @RuneAttribute(value="recordTransfer", isRequired=true)
        public Transfer getRecordTransfer() {
            return this.recordTransfer;
        }

        @Override
        @RosettaAttribute(value="recordStartDate", isRequired=true)
        @RuneAttribute(value="recordStartDate", isRequired=true)
        public Date getRecordStartDate() {
            return this.recordStartDate;
        }

        @Override
        @RosettaAttribute(value="recordEndDate", isRequired=true)
        @RuneAttribute(value="recordEndDate", isRequired=true)
        public Date getRecordEndDate() {
            return this.recordEndDate;
        }

        @Override
        @RosettaAttribute(value="minimumFee")
        @RuneAttribute(value="minimumFee")
        public Money getMinimumFee() {
            return this.minimumFee;
        }

        @Override
        public BillingRecord build() {
            return this;
        }

        @Override
        public BillingRecordBuilder toBuilder() {
            BillingRecordBuilder builder = BillingRecord.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(BillingRecordBuilder builder) {
            Optional.ofNullable(this.getTradeState()).ifPresent(builder::setTradeState);
            Optional.ofNullable(this.getRecordTransfer()).ifPresent(builder::setRecordTransfer);
            Optional.ofNullable(this.getRecordStartDate()).ifPresent(builder::setRecordStartDate);
            Optional.ofNullable(this.getRecordEndDate()).ifPresent(builder::setRecordEndDate);
            Optional.ofNullable(this.getMinimumFee()).ifPresent(builder::setMinimumFee);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            BillingRecord _that = this.getType().cast(o);
            if (!Objects.equals(this.tradeState, _that.getTradeState())) {
                return false;
            }
            if (!Objects.equals(this.recordTransfer, _that.getRecordTransfer())) {
                return false;
            }
            if (!Objects.equals(this.recordStartDate, _that.getRecordStartDate())) {
                return false;
            }
            if (!Objects.equals(this.recordEndDate, _that.getRecordEndDate())) {
                return false;
            }
            return Objects.equals(this.minimumFee, _that.getMinimumFee());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.tradeState != null ? this.tradeState.hashCode() : 0);
            _result = 31 * _result + (this.recordTransfer != null ? this.recordTransfer.hashCode() : 0);
            _result = 31 * _result + (this.recordStartDate != null ? this.recordStartDate.hashCode() : 0);
            _result = 31 * _result + (this.recordEndDate != null ? this.recordEndDate.hashCode() : 0);
            _result = 31 * _result + (this.minimumFee != null ? this.minimumFee.hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "BillingRecord {tradeState=" + this.tradeState + ", recordTransfer=" + this.recordTransfer + ", recordStartDate=" + this.recordStartDate + ", recordEndDate=" + this.recordEndDate + ", minimumFee=" + this.minimumFee + '}';
        }
    }
}

