/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.DatedValue;
import cdm.base.math.UnitType;
import cdm.observable.asset.CashPrice;
import cdm.observable.asset.PriceComposite;
import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import cdm.observable.asset.meta.PriceMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

@RosettaDataType(value="Price", builder=PriceBuilderImpl.class, version="5.30.0")
@RuneDataType(value="Price", model="cdm", builder=PriceBuilderImpl.class, version="5.30.0")
public interface Price
extends PriceSchedule {
    public static final PriceMeta metaData = new PriceMeta();

    @Override
    public Price build();

    @Override
    public PriceBuilder toBuilder();

    public static PriceBuilder builder() {
        return new PriceBuilderImpl();
    }

    default public RosettaMetaData<? extends Price> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Price> getType() {
        return Price.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("unit"), processor, UnitType.class, this.getUnit(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.class, this.getDatedValue(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("perUnitOf"), processor, UnitType.class, this.getPerUnitOf(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceType"), PriceTypeEnum.class, (Object)this.getPriceType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("composite"), processor, PriceComposite.class, this.getComposite(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("arithmeticOperator"), ArithmeticOperationEnum.class, (Object)this.getArithmeticOperator(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("cashPrice"), processor, CashPrice.class, this.getCashPrice(), new AttributeMeta[0]);
    }

    public static class PriceBuilderImpl
    extends PriceSchedule.PriceScheduleBuilderImpl
    implements PriceBuilder {
        @Override
        @RosettaAttribute(value="value")
        @RuneAttribute(value="value")
        public PriceBuilder setValue(BigDecimal _value) {
            this.value = _value == null ? null : _value;
            return this;
        }

        @Override
        @RosettaAttribute(value="unit")
        @RuneAttribute(value="unit")
        public PriceBuilder setUnit(UnitType _unit) {
            this.unit = _unit == null ? null : _unit.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="datedValue")
        @RuneAttribute(value="datedValue")
        public PriceBuilder addDatedValue(DatedValue _datedValue) {
            if (_datedValue != null) {
                this.datedValue.add(_datedValue.toBuilder());
            }
            return this;
        }

        @Override
        public PriceBuilder addDatedValue(DatedValue _datedValue, int idx) {
            this.getIndex(this.datedValue, idx, () -> _datedValue.toBuilder());
            return this;
        }

        @Override
        public PriceBuilder addDatedValue(List<? extends DatedValue> datedValues) {
            if (datedValues != null) {
                for (DatedValue datedValue : datedValues) {
                    this.datedValue.add(datedValue.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="datedValue")
        public PriceBuilder setDatedValue(List<? extends DatedValue> datedValues) {
            this.datedValue = datedValues == null ? new ArrayList() : (List)datedValues.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="perUnitOf")
        @RuneAttribute(value="perUnitOf")
        public PriceBuilder setPerUnitOf(UnitType _perUnitOf) {
            this.perUnitOf = _perUnitOf == null ? null : _perUnitOf.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="priceType", isRequired=true)
        @RuneAttribute(value="priceType", isRequired=true)
        public PriceBuilder setPriceType(PriceTypeEnum _priceType) {
            this.priceType = _priceType == null ? null : _priceType;
            return this;
        }

        @Override
        @RosettaAttribute(value="priceExpression")
        @RuneAttribute(value="priceExpression")
        public PriceBuilder setPriceExpression(PriceExpressionEnum _priceExpression) {
            this.priceExpression = _priceExpression == null ? null : _priceExpression;
            return this;
        }

        @Override
        @RosettaAttribute(value="composite")
        @RuneAttribute(value="composite")
        public PriceBuilder setComposite(PriceComposite _composite) {
            this.composite = _composite == null ? null : _composite.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="arithmeticOperator")
        @RuneAttribute(value="arithmeticOperator")
        public PriceBuilder setArithmeticOperator(ArithmeticOperationEnum _arithmeticOperator) {
            this.arithmeticOperator = _arithmeticOperator == null ? null : _arithmeticOperator;
            return this;
        }

        @Override
        @RosettaAttribute(value="cashPrice")
        @RuneAttribute(value="cashPrice")
        public PriceBuilder setCashPrice(CashPrice _cashPrice) {
            this.cashPrice = _cashPrice == null ? null : _cashPrice.toBuilder();
            return this;
        }

        @Override
        public Price build() {
            return new PriceImpl(this);
        }

        @Override
        public PriceBuilder toBuilder() {
            return this;
        }

        @Override
        public PriceBuilder prune() {
            super.prune();
            return this;
        }

        @Override
        public boolean hasData() {
            return super.hasData();
        }

        @Override
        public PriceBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            PriceBuilder o = (PriceBuilder)other;
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "PriceBuilder {} " + super.toString();
        }
    }

    public static interface PriceBuilder
    extends Price,
    PriceSchedule.PriceScheduleBuilder {
        @Override
        public PriceBuilder setValue(BigDecimal var1);

        @Override
        public PriceBuilder setUnit(UnitType var1);

        @Override
        public PriceBuilder addDatedValue(DatedValue var1);

        @Override
        public PriceBuilder addDatedValue(DatedValue var1, int var2);

        @Override
        public PriceBuilder addDatedValue(List<? extends DatedValue> var1);

        @Override
        public PriceBuilder setDatedValue(List<? extends DatedValue> var1);

        @Override
        public PriceBuilder setPerUnitOf(UnitType var1);

        @Override
        public PriceBuilder setPriceType(PriceTypeEnum var1);

        @Override
        public PriceBuilder setPriceExpression(PriceExpressionEnum var1);

        @Override
        public PriceBuilder setComposite(PriceComposite var1);

        @Override
        public PriceBuilder setArithmeticOperator(ArithmeticOperationEnum var1);

        @Override
        public PriceBuilder setCashPrice(CashPrice var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("value"), BigDecimal.class, (Object)this.getValue(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("unit"), processor, UnitType.UnitTypeBuilder.class, (RosettaModelObjectBuilder)this.getUnit(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("datedValue"), processor, DatedValue.DatedValueBuilder.class, this.getDatedValue(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("perUnitOf"), processor, UnitType.UnitTypeBuilder.class, (RosettaModelObjectBuilder)this.getPerUnitOf(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceType"), PriceTypeEnum.class, (Object)this.getPriceType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("priceExpression"), PriceExpressionEnum.class, (Object)this.getPriceExpression(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("composite"), processor, PriceComposite.PriceCompositeBuilder.class, (RosettaModelObjectBuilder)this.getComposite(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("arithmeticOperator"), ArithmeticOperationEnum.class, (Object)this.getArithmeticOperator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("cashPrice"), processor, CashPrice.CashPriceBuilder.class, (RosettaModelObjectBuilder)this.getCashPrice(), new AttributeMeta[0]);
        }

        @Override
        public PriceBuilder prune();
    }

    public static class PriceImpl
    extends PriceSchedule.PriceScheduleImpl
    implements Price {
        protected PriceImpl(PriceBuilder builder) {
            super(builder);
        }

        @Override
        public Price build() {
            return this;
        }

        @Override
        public PriceBuilder toBuilder() {
            PriceBuilder builder = Price.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(PriceBuilder builder) {
            super.setBuilderFields(builder);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            return super.equals(o);
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            return _result;
        }

        @Override
        public String toString() {
            return "Price {} " + super.toString();
        }
    }
}

