/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.datetime.functions.DateDifference;
import cdm.base.datetime.functions.PopOffDateList;
import cdm.base.math.functions.AppendToVector;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=GenerateWeightsDefault.class)
public abstract class GenerateWeights
implements RosettaFunction {
    @Inject
    protected AppendToVector appendToVector;
    @Inject
    protected DateDifference dateDifference;
    @Inject
    protected GenerateWeights generateWeights;
    @Inject
    protected PopOffDateList popOffDateList;

    public List<BigDecimal> evaluate(List<Date> weightingDates) {
        List<BigDecimal> weights = this.doEvaluate(weightingDates);
        return weights;
    }

    protected abstract List<BigDecimal> doEvaluate(List<Date> var1);

    protected abstract MapperS<Boolean> active(List<Date> var1);

    protected abstract MapperS<Date> refDate(List<Date> var1);

    protected abstract MapperC<Date> remainingDates(List<Date> var1);

    protected abstract MapperS<Date> prevDate(List<Date> var1);

    protected abstract MapperS<Integer> diff(List<Date> var1);

    protected abstract MapperC<BigDecimal> remainingWeights(List<Date> var1);

    public static class GenerateWeightsDefault
    extends GenerateWeights {
        @Override
        protected List<BigDecimal> doEvaluate(List<Date> weightingDates) {
            if (weightingDates == null) {
                weightingDates = Collections.emptyList();
            }
            ArrayList<BigDecimal> weights = new ArrayList<BigDecimal>();
            return this.assignOutput(weights, weightingDates);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> weights, List<Date> weightingDates) {
            if (((Boolean)this.active(weightingDates).getOrDefault((Object)false)).booleanValue()) {
                weights.addAll(this.appendToVector.evaluate(this.remainingWeights(weightingDates).getMulti(), (BigDecimal)MapperMaths.multiply((Mapper)this.diff(weightingDates).map("Type coercion", integer -> integer == null ? null : BigDecimal.valueOf(integer.intValue())), (Mapper)MapperS.of((Object)new BigDecimal("1.0"))).get()));
            } else {
                weights.addAll(Collections.emptyList());
            }
            return weights;
        }

        @Override
        protected MapperS<Boolean> active(List<Date> weightingDates) {
            return ExpressionOperators.greaterThan((Mapper)MapperS.of((Object)MapperC.of(weightingDates).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All).asMapper();
        }

        @Override
        protected MapperS<Date> refDate(List<Date> weightingDates) {
            return MapperC.of(weightingDates).last();
        }

        @Override
        protected MapperC<Date> remainingDates(List<Date> weightingDates) {
            return MapperC.of(this.popOffDateList.evaluate(weightingDates));
        }

        @Override
        protected MapperS<Date> prevDate(List<Date> weightingDates) {
            return this.remainingDates(weightingDates).last();
        }

        @Override
        protected MapperS<Integer> diff(List<Date> weightingDates) {
            return MapperS.of((Object)this.dateDifference.evaluate((Date)this.prevDate(weightingDates).get(), (Date)this.refDate(weightingDates).get()));
        }

        @Override
        protected MapperC<BigDecimal> remainingWeights(List<Date> weightingDates) {
            return MapperC.of(this.generateWeights.evaluate(this.remainingDates(weightingDates).getMulti()));
        }
    }
}

