/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.common.schedule.validation.datarule;

import cdm.product.common.schedule.ParametricDates;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperators;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ParametricDatesDayOfWeekMethod")
@ImplementedBy(value=Default.class)
public interface ParametricDatesDayOfWeekMethod
extends Validator<ParametricDates> {
    public static final String NAME = "ParametricDatesDayOfWeekMethod";
    public static final String DEFINITION = "if dayOfWeek exists then dayFrequency exists";

    public static class NoOp
    implements ParametricDatesDayOfWeekMethod {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ParametricDates parametricDates) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ParametricDatesDayOfWeekMethod {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ParametricDates parametricDates) {
            ComparisonResult result = this.executeDataRule(parametricDates);
            if (result.get().booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ParametricDatesDayOfWeekMethod.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ParametricDates", (RosettaPath)path, (String)ParametricDatesDayOfWeekMethod.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ParametricDatesDayOfWeekMethod.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ParametricDates", (RosettaPath)path, (String)ParametricDatesDayOfWeekMethod.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ParametricDates parametricDates) {
            try {
                if (ExpressionOperators.exists((Mapper)MapperS.of((Object)parametricDates).mapC("getDayOfWeek", _parametricDates -> _parametricDates.getDayOfWeek())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperators.exists((Mapper)MapperS.of((Object)parametricDates).map("getDayFrequency", _parametricDates -> _parametricDates.getDayFrequency()));
                }
                return ComparisonResult.successEmptyOperand((String)"");
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

