/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib;

import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.Processor;
import java.util.ArrayList;
import java.util.List;

public interface RosettaModelObject {
    public RosettaModelObjectBuilder toBuilder();

    public RosettaModelObject build();

    public RosettaMetaData<? extends RosettaModelObject> metaData();

    public Class<? extends RosettaModelObject> getType();

    public void process(RosettaPath var1, Processor var2);

    default public <R extends RosettaModelObject> void processRosetta(RosettaPath path, Processor processor, Class<R> clazz, R child, AttributeMeta ... metas) {
        boolean processFurther = processor.processRosetta(path, clazz, child, this, metas);
        if (child != null && processFurther) {
            child.process(path, processor);
        }
    }

    default public <R extends RosettaModelObject> void processRosetta(RosettaPath path, Processor processor, Class<R> clazz, List<? extends R> children, AttributeMeta ... metas) {
        boolean processFurther = processor.processRosetta(path, clazz, children, this, metas);
        if (children != null && processFurther) {
            int index = 0;
            ArrayList<R> copy = new ArrayList<R>(children);
            for (RosettaModelObject child : copy) {
                if (child == null) continue;
                RosettaPath indexedPath = path.withIndex(index);
                child.process(indexedPath, processor);
                ++index;
            }
        }
    }
}

