/*
 * Decompiled with CFR 0.152.
 */
package com.rosetta.model.lib.expression;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionCompareUtilNullSafe;
import com.rosetta.model.lib.expression.ExpressionEqualityUtilNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;

public class ExpressionOperatorsNullSafe {
    public static <T> ComparisonResult notExists(Mapper<T> o) {
        if (o.resultCount() == 0) {
            return ComparisonResult.success();
        }
        return ComparisonResult.failure(o.getPaths() + " does exist and is " + ExpressionOperatorsNullSafe.formatMultiError(o));
    }

    public static <T> ComparisonResult exists(Mapper<T> o) {
        if (o.resultCount() > 0) {
            return ComparisonResult.success();
        }
        return ComparisonResult.failure(o.getErrorPaths() + " does not exist");
    }

    public static <T> ComparisonResult singleExists(Mapper<T> o) {
        if (o.resultCount() == 1) {
            return ComparisonResult.success();
        }
        String error = o.resultCount() > 0 ? String.format("Expected single %s but found %s [%s]", o.getPaths(), o.resultCount(), ExpressionOperatorsNullSafe.formatMultiError(o)) : String.format("Expected single %s but found zero", o.getErrorPaths());
        return ComparisonResult.failure(error);
    }

    public static <T> ComparisonResult multipleExists(Mapper<T> o) {
        if (o.resultCount() > 1) {
            return ComparisonResult.success();
        }
        String error = o.resultCount() > 0 ? String.format("Expected multiple %s but only one [%s]", o.getPaths(), ExpressionOperatorsNullSafe.formatMultiError(o)) : String.format("Expected multiple %s but found zero", o.getErrorPaths());
        return ComparisonResult.failure(error);
    }

    @Deprecated
    public static ComparisonResult onlyExists(List<? extends Mapper<?>> o) {
        Set parents = o.stream().map(Mapper::getParentMulti).flatMap(Collection::stream).map(RosettaModelObject.class::cast).collect(Collectors.toSet());
        if (parents.size() == 0) {
            return ComparisonResult.failure("No fields set.");
        }
        Set fields = o.stream().flatMap(m -> Stream.concat(m.getPaths().stream(), m.getErrorPaths().stream())).map(ExpressionOperatorsNullSafe::getAttributeName).collect(Collectors.toSet());
        if (fields.size() != o.size()) {
            return ComparisonResult.failure("All required fields not set.");
        }
        return parents.stream().map(p -> ExpressionOperatorsNullSafe.validateOnlyExists(p, fields)).reduce(ComparisonResult.success(), (a, b) -> a.andNullSafe((ComparisonResult)b));
    }

    public static <T> ComparisonResult onlyExists(Mapper<T> mapper, List<String> allFieldNames, List<String> requiredFields) {
        List<T> objects = mapper.getMulti();
        if (objects == null || objects.isEmpty()) {
            String requiredFieldsMessage = requiredFields.stream().collect(Collectors.joining("', '", "'", "'"));
            String errorMessage = String.format("Expected only %s to be set, but object was absent.", requiredFieldsMessage);
            return ComparisonResult.failure(errorMessage);
        }
        return objects.stream().map(p -> ExpressionOperatorsNullSafe.validateOnlyExists(p, allFieldNames, requiredFields)).reduce(ComparisonResult.success(), (a, b) -> a.andNullSafe((ComparisonResult)b));
    }

    private static <T> ComparisonResult validateOnlyExists(T object, List<String> allFieldNames, List<String> requiredFields) {
        String errorMessage;
        LinkedList<String> populatedFieldNames = new LinkedList<String>();
        for (String a : allFieldNames) {
            try {
                Method getter = object.getClass().getMethod("get" + StringUtils.capitalize((String)a), new Class[0]);
                if (!ExistenceChecker.isSet(getter.invoke(object, new Object[0]))) continue;
                populatedFieldNames.add(a);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (new HashSet(populatedFieldNames).equals(new HashSet<String>(requiredFields))) {
            return ComparisonResult.success();
        }
        String requiredFieldsMessage = requiredFields.stream().collect(Collectors.joining("', '", "'", "'"));
        if (populatedFieldNames.size() == 0) {
            errorMessage = String.format("Expected only %s to be set, but no fields were set.", requiredFieldsMessage);
        } else {
            String setFields = populatedFieldNames.stream().collect(Collectors.joining("', '", "'", "'"));
            errorMessage = String.format("Expected only %s to be set, but set fields are: %s.", requiredFieldsMessage, setFields);
        }
        return ComparisonResult.failure(errorMessage);
    }

    private static String getAttributeName(Mapper.Path p) {
        String attr = p.getLastName();
        return "value".equals(attr) || "reference".equals(attr) || "globalReference".equals(attr) ? p.getNames().get(p.getNames().size() - 2) : attr;
    }

    @Deprecated
    private static <T extends RosettaModelObject> ComparisonResult validateOnlyExists(T parent, Set<String> fields) {
        RosettaMetaData<? extends RosettaModelObject> meta = parent.metaData();
        ValidatorWithArg<? extends RosettaModelObject, Set<String>> onlyExistsValidator = meta.onlyExistsValidator();
        if (onlyExistsValidator != null) {
            ValidationResult<? extends RosettaModelObject> validationResult = onlyExistsValidator.validate(null, parent, fields);
            return validationResult.isSuccess() ? ComparisonResult.success() : ComparisonResult.failure(validationResult.getFailureReason().orElse(""));
        }
        return ComparisonResult.success();
    }

    public static <T, A extends Mapper<T>> A doIf(Mapper<Boolean> test, Supplier<A> ifthen, Supplier<A> elsethen) {
        boolean testResult = test.getMulti().stream().allMatch(Boolean::booleanValue);
        if (testResult) {
            return (A)((Mapper)ifthen.get());
        }
        return (A)((Mapper)elsethen.get());
    }

    public static <T, A extends Mapper<T>> A doIf(Mapper<Boolean> test, Supplier<A> ifthen) {
        return (A)ExpressionOperatorsNullSafe.doIf(test, ifthen, () -> MapperS.of(null));
    }

    public static ComparisonResult resultDoIf(Mapper<Boolean> test, Supplier<Mapper<Boolean>> ifthen, Supplier<Mapper<Boolean>> elsethen) {
        boolean testResult = test.getMulti().stream().allMatch(Boolean::booleanValue);
        if (testResult) {
            return ExpressionOperatorsNullSafe.toComparisonResult(ifthen.get());
        }
        return ExpressionOperatorsNullSafe.toComparisonResult(elsethen.get());
    }

    public static ComparisonResult resultDoIf(Mapper<Boolean> test, Supplier<Mapper<Boolean>> ifthen) {
        return ExpressionOperatorsNullSafe.resultDoIf(test, ifthen, () -> ComparisonResult.success());
    }

    private static ComparisonResult toComparisonResult(Mapper<Boolean> mapper) {
        if (mapper instanceof ComparisonResult) {
            return (ComparisonResult)mapper;
        }
        return mapper.getMulti().stream().allMatch(Boolean::booleanValue) ? ComparisonResult.success() : ComparisonResult.failure("");
    }

    public static <T, U> ComparisonResult areEqual(Mapper<T> m1, Mapper<U> m2, CardinalityOperator o) {
        return ExpressionEqualityUtilNullSafe.evaluate(m1, m2, o, ExpressionEqualityUtilNullSafe::areEqual);
    }

    public static <T, U> ComparisonResult notEqual(Mapper<T> m1, Mapper<U> m2, CardinalityOperator o) {
        return ExpressionEqualityUtilNullSafe.evaluate(m1, m2, o, ExpressionEqualityUtilNullSafe::notEqual);
    }

    public static <T extends Comparable<? super T>> ComparisonResult notEqual(ComparisonResult r1, ComparisonResult r2) {
        return r1.get() != r2.get() ? ComparisonResult.success() : ComparisonResult.failure("Results are not equal");
    }

    public static <T extends Comparable<? super T>, U extends Comparable<? super U>> ComparisonResult greaterThan(Mapper<T> m1, Mapper<U> m2, CardinalityOperator o) {
        return ExpressionCompareUtilNullSafe.evaluate(m1, m2, o, ExpressionCompareUtilNullSafe::greaterThan);
    }

    public static <T extends Comparable<? super T>, U extends Comparable<? super U>> ComparisonResult greaterThanEquals(Mapper<T> m1, Mapper<U> m2, CardinalityOperator o) {
        return ExpressionCompareUtilNullSafe.evaluate(m1, m2, o, ExpressionCompareUtilNullSafe::greaterThanEquals);
    }

    public static <T extends Comparable<? super T>, U extends Comparable<? super U>> ComparisonResult lessThan(Mapper<T> m1, Mapper<U> m2, CardinalityOperator o) {
        return ExpressionCompareUtilNullSafe.evaluate(m1, m2, o, ExpressionCompareUtilNullSafe::lessThan);
    }

    public static <T extends Comparable<? super T>, U extends Comparable<? super U>> ComparisonResult lessThanEquals(Mapper<T> m1, Mapper<U> m2, CardinalityOperator o) {
        return ExpressionCompareUtilNullSafe.evaluate(m1, m2, o, ExpressionCompareUtilNullSafe::lessThanEquals);
    }

    public static <T> ComparisonResult contains(Mapper<? extends T> o1, Mapper<? extends T> o2) {
        if (o1.getMulti().isEmpty()) {
            return ComparisonResult.failure("Empty list does not contain all of " + ExpressionOperatorsNullSafe.formatMultiError(o2));
        }
        if (o2.getMulti().isEmpty()) {
            return ComparisonResult.failure(ExpressionOperatorsNullSafe.formatMultiError(o1) + " does not contain empty list");
        }
        boolean result = o1.getMulti().containsAll(o2.getMulti());
        if (result) {
            return ComparisonResult.success();
        }
        return ComparisonResult.failure(ExpressionOperatorsNullSafe.formatMultiError(o1) + " does not contain all of " + ExpressionOperatorsNullSafe.formatMultiError(o2));
    }

    public static <T> ComparisonResult disjoint(Mapper<T> o1, Mapper<T> o2) {
        List<T> multi2 = o2.getMulti();
        List<T> multi1 = o1.getMulti();
        boolean result = Collections.disjoint(multi1, multi2);
        if (result) {
            return ComparisonResult.success();
        }
        Collection common = multi1.stream().filter(multi2::contains).collect(Collectors.toSet());
        return ComparisonResult.failure(ExpressionOperatorsNullSafe.formatMultiError(o1) + " is not disjoint from " + ExpressionOperatorsNullSafe.formatMultiError(o2) + "common items are " + common);
    }

    public static <T> MapperC<T> distinct(Mapper<T> o) {
        return MapperC.of(o.getMulti().stream().distinct().collect(Collectors.toList()));
    }

    public static ComparisonResult checkCardinality(String msgPrefix, int actual, int min, int max) {
        if (actual < min) {
            if (actual == 0) {
                return ComparisonResult.failure("'" + msgPrefix + "' is a required field but does not exist.");
            }
            return ComparisonResult.failure("Minimum of " + min + " '" + msgPrefix + "' is expected but found " + actual + ".");
        }
        if (max > 0 && actual > max) {
            return ComparisonResult.failure("Maximum of " + max + " '" + msgPrefix + "' are expected but found " + actual + ".");
        }
        return ComparisonResult.success();
    }

    public static ComparisonResult checkString(String msgPrefix, String value, int minLength, Optional<Integer> maxLength, Optional<Pattern> pattern) {
        Pattern p;
        Matcher match;
        if (value == null) {
            return ComparisonResult.success();
        }
        ArrayList<String> failures = new ArrayList<String>();
        if (value.length() < minLength) {
            failures.add("Field '" + msgPrefix + "' requires a value with minimum length of " + minLength + " characters but value '" + value + "' has length of " + value.length() + " characters.");
        }
        if (maxLength.isPresent()) {
            int m = maxLength.get();
            if (value.length() > m) {
                failures.add("Field '" + msgPrefix + "' must have a value with maximum length of " + m + " characters but value '" + value + "' has length of " + value.length() + " characters.");
            }
        }
        if (pattern.isPresent() && !(match = (p = pattern.get()).matcher(value)).matches()) {
            failures.add("Field '" + msgPrefix + "' with value '" + value + "' does not match the pattern /" + p.toString() + "/.");
        }
        if (failures.isEmpty()) {
            return ComparisonResult.success();
        }
        return ComparisonResult.failure(failures.stream().collect(Collectors.joining(" ")));
    }

    public static ComparisonResult checkString(String msgPrefix, List<String> values, int minLength, Optional<Integer> maxLength, Optional<Pattern> pattern) {
        if (values == null) {
            return ComparisonResult.success();
        }
        List failures = values.stream().map(v -> ExpressionOperatorsNullSafe.checkString(msgPrefix, v, minLength, maxLength, pattern)).filter(r -> r.get() == false).map(r -> r.getError()).collect(Collectors.toList());
        if (failures.isEmpty()) {
            return ComparisonResult.success();
        }
        return ComparisonResult.failure(failures.stream().collect(Collectors.joining(" - ")));
    }

    public static ComparisonResult checkNumber(String msgPrefix, BigDecimal value, Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max) {
        BigDecimal m;
        int actual;
        BigDecimal normalized;
        if (value == null) {
            return ComparisonResult.success();
        }
        ArrayList<String> failures = new ArrayList<String>();
        if (digits.isPresent()) {
            int d = digits.get();
            normalized = value.stripTrailingZeros();
            actual = normalized.precision();
            if (normalized.scale() >= normalized.precision()) {
                actual = normalized.scale() + 1;
            }
            if (normalized.scale() < 0) {
                actual -= normalized.scale();
            }
            if (actual > d) {
                failures.add("Expected a maximum of " + d + " digits for '" + msgPrefix + "', but the number " + value + " has " + actual + ".");
            }
        }
        if (fractionalDigits.isPresent()) {
            int f = fractionalDigits.get();
            normalized = value.stripTrailingZeros();
            actual = normalized.scale();
            if (normalized.scale() < 0) {
                actual = 0;
            }
            if (actual > f) {
                failures.add("Expected a maximum of " + f + " fractional digits for '" + msgPrefix + "', but the number " + value + " has " + actual + ".");
            }
        }
        if (min.isPresent() && value.compareTo(m = min.get()) < 0) {
            failures.add("Expected a number greater than or equal to " + m.toPlainString() + " for '" + msgPrefix + "', but found " + value + ".");
        }
        if (max.isPresent() && value.compareTo(m = max.get()) > 0) {
            failures.add("Expected a number less than or equal to " + m.toPlainString() + " for '" + msgPrefix + "', but found " + value + ".");
        }
        if (failures.isEmpty()) {
            return ComparisonResult.success();
        }
        return ComparisonResult.failure(failures.stream().collect(Collectors.joining(" ")));
    }

    public static ComparisonResult checkNumber(String msgPrefix, Integer value, Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max) {
        if (value == null) {
            return ComparisonResult.success();
        }
        return ExpressionOperatorsNullSafe.checkNumber(msgPrefix, BigDecimal.valueOf(value.intValue()), digits, fractionalDigits, min, max);
    }

    public static ComparisonResult checkNumber(String msgPrefix, Long value, Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max) {
        if (value == null) {
            return ComparisonResult.success();
        }
        return ExpressionOperatorsNullSafe.checkNumber(msgPrefix, BigDecimal.valueOf(value), digits, fractionalDigits, min, max);
    }

    public static ComparisonResult checkNumber(String msgPrefix, BigInteger value, Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max) {
        if (value == null) {
            return ComparisonResult.success();
        }
        return ExpressionOperatorsNullSafe.checkNumber(msgPrefix, new BigDecimal(value), digits, fractionalDigits, min, max);
    }

    public static ComparisonResult checkNumber(String msgPrefix, List<? extends Number> values, Optional<Integer> digits, Optional<Integer> fractionalDigits, Optional<BigDecimal> min, Optional<BigDecimal> max) {
        if (values == null) {
            return ComparisonResult.success();
        }
        List failures = values.stream().map(v -> {
            if (v instanceof BigDecimal) {
                return ExpressionOperatorsNullSafe.checkNumber(msgPrefix, (BigDecimal)v, digits, fractionalDigits, min, max);
            }
            return ExpressionOperatorsNullSafe.checkNumber(msgPrefix, v.longValue(), digits, fractionalDigits, min, max);
        }).filter(r -> r.get() == false).map(r -> r.getError()).collect(Collectors.toList());
        if (failures.isEmpty()) {
            return ComparisonResult.success();
        }
        return ComparisonResult.failure(failures.stream().collect(Collectors.joining(" - ")));
    }

    private static <T> String formatMultiError(Mapper<T> o) {
        Object t = o.getMulti().stream().findAny().orElse(null);
        return t instanceof RosettaModelObject ? t.getClass().getSimpleName() : o.getMulti().toString();
    }

    @Deprecated
    public static <T> ComparisonResult choice(Mapper<T> mapper, List<String> choiceFieldNames, ValidationResult.ChoiceRuleValidationMethod necessity) {
        return ExpressionOperatorsNullSafe.choice(mapper, choiceFieldNames, necessity == ValidationResult.ChoiceRuleValidationMethod.OPTIONAL ? ChoiceRuleValidationMethod.OPTIONAL : ChoiceRuleValidationMethod.REQUIRED);
    }

    public static <T> ComparisonResult choice(Mapper<T> mapper, List<String> choiceFieldNames, ChoiceRuleValidationMethod necessity) {
        T object = mapper.get();
        LinkedList<String> populatedFieldNames = new LinkedList<String>();
        for (String a : choiceFieldNames) {
            try {
                Method getter = object.getClass().getMethod("get" + StringUtils.capitalize((String)a), new Class[0]);
                if (!ExistenceChecker.isSet(getter.invoke(object, new Object[0]))) continue;
                populatedFieldNames.add(a);
            }
            catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        if (necessity.check(populatedFieldNames.size())) {
            return ComparisonResult.success();
        }
        String definition = choiceFieldNames.stream().collect(Collectors.joining("', '", necessity.getDescription() + " of '", "'. "));
        String errorMessage = definition + (populatedFieldNames.isEmpty() ? "No fields are set." : populatedFieldNames.stream().collect(Collectors.joining("', '", "Set fields are '", "'.")));
        return ComparisonResult.failure(errorMessage);
    }

    static interface CompareFunction<T, U> {
        public ComparisonResult apply(T var1, U var2, CardinalityOperator var3);
    }
}

