/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.google.common.collect.Iterables;
import com.opengamma.strata.basics.currency.Currency;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.Tenor;
import com.opengamma.strata.basics.index.FloatingRateIndex;
import com.opengamma.strata.basics.index.FloatingRateNameIniLookup;
import com.opengamma.strata.basics.index.FloatingRateNames;
import com.opengamma.strata.basics.index.FloatingRateType;
import com.opengamma.strata.basics.index.IborIndex;
import com.opengamma.strata.basics.index.OvernightIndex;
import com.opengamma.strata.basics.index.PriceIndex;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import java.util.Optional;
import java.util.Set;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface FloatingRateName
extends Named {
    @FromString
    public static FloatingRateName of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (FloatingRateName)FloatingRateName.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<FloatingRateName> extendedEnum() {
        return FloatingRateNames.ENUM_LOOKUP;
    }

    public static FloatingRateName parse(String str) {
        ArgChecker.notNull((Object)str, (String)"str");
        Optional frnOpt = FloatingRateName.extendedEnum().find(str);
        if (frnOpt.isPresent()) {
            return (FloatingRateName)frnOpt.get();
        }
        return FloatingRateIndex.parse(str).getFloatingRateName();
    }

    public static FloatingRateName defaultIborIndex(Currency currency) {
        return FloatingRateNameIniLookup.INSTANCE.defaultIborIndex(currency);
    }

    public static FloatingRateName defaultOvernightIndex(Currency currency) {
        return FloatingRateNameIniLookup.INSTANCE.defaultOvernightIndex(currency);
    }

    @ToString
    public String getName();

    public FloatingRateType getType();

    default public Currency getCurrency() {
        return this.toFloatingRateIndex().getCurrency();
    }

    public Set<Tenor> getTenors();

    default public Tenor getDefaultTenor() {
        switch (this.getType()) {
            case IBOR: {
                Set<Tenor> tenors = this.getTenors();
                if (tenors.contains(Tenor.TENOR_3M)) {
                    return Tenor.TENOR_3M;
                }
                if (tenors.contains(Tenor.TENOR_13W)) {
                    return Tenor.TENOR_13W;
                }
                return tenors.iterator().next();
            }
            case OVERNIGHT_AVERAGED: 
            case OVERNIGHT_COMPOUNDED: {
                return Tenor.TENOR_1D;
            }
        }
        return Tenor.TENOR_1Y;
    }

    public FloatingRateName normalized();

    default public FloatingRateIndex toFloatingRateIndex() {
        switch (this.getType()) {
            case IBOR: {
                return this.toIborIndex(this.getDefaultTenor());
            }
            case OVERNIGHT_AVERAGED: 
            case OVERNIGHT_COMPOUNDED: {
                return this.toOvernightIndex();
            }
            case PRICE: {
                return this.toPriceIndex();
            }
        }
        throw new IllegalArgumentException("Floating rate index type not known: " + (Object)((Object)this.getType()));
    }

    default public FloatingRateIndex toFloatingRateIndex(Tenor iborTenor) {
        switch (this.getType()) {
            case IBOR: {
                return this.toIborIndex(iborTenor);
            }
            case OVERNIGHT_AVERAGED: 
            case OVERNIGHT_COMPOUNDED: {
                return this.toOvernightIndex();
            }
            case PRICE: {
                return this.toPriceIndex();
            }
        }
        throw new IllegalArgumentException("Floating rate index type not known: " + (Object)((Object)this.getType()));
    }

    public IborIndex toIborIndex(Tenor var1);

    default public DaysAdjustment toIborIndexFixingOffset() {
        return this.toIborIndex((Tenor)Iterables.getFirst(this.getTenors(), (Object)Tenor.TENOR_3M)).getFixingDateOffset();
    }

    public OvernightIndex toOvernightIndex();

    public PriceIndex toPriceIndex();
}

