/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.index;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.currency.CurrencyPair;
import com.opengamma.strata.basics.date.DaysAdjustment;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.index.FxIndexObservation;
import com.opengamma.strata.basics.index.FxIndices;
import com.opengamma.strata.basics.index.Index;
import com.opengamma.strata.collect.ArgChecker;
import com.opengamma.strata.collect.named.ExtendedEnum;
import com.opengamma.strata.collect.named.Named;
import java.time.LocalDate;
import java.util.function.Function;
import org.joda.convert.FromString;
import org.joda.convert.ToString;

public interface FxIndex
extends Index,
Named {
    @FromString
    public static FxIndex of(String uniqueName) {
        ArgChecker.notNull((Object)uniqueName, (String)"uniqueName");
        return (FxIndex)FxIndex.extendedEnum().lookup(uniqueName);
    }

    public static ExtendedEnum<FxIndex> extendedEnum() {
        return FxIndices.ENUM_LOOKUP;
    }

    public CurrencyPair getCurrencyPair();

    public DaysAdjustment getFixingDateOffset();

    public DaysAdjustment getMaturityDateOffset();

    public HolidayCalendarId getFixingCalendar();

    public LocalDate calculateMaturityFromFixing(LocalDate var1, ReferenceData var2);

    public LocalDate calculateFixingFromMaturity(LocalDate var1, ReferenceData var2);

    public Function<LocalDate, FxIndexObservation> resolve(ReferenceData var1);

    @ToString
    public String getName();
}

