/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.schedule;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.AdjustableDate;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import com.opengamma.strata.basics.schedule.Frequency;
import com.opengamma.strata.basics.schedule.RollConvention;
import com.opengamma.strata.basics.schedule.RollConventions;
import com.opengamma.strata.basics.schedule.Schedule;
import com.opengamma.strata.basics.schedule.ScheduleException;
import com.opengamma.strata.basics.schedule.SchedulePeriod;
import com.opengamma.strata.basics.schedule.StubConvention;
import com.opengamma.strata.collect.ArgChecker;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import org.joda.beans.Bean;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectFieldsBeanBuilder;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;

@BeanDefinition
public final class PeriodicSchedule
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate startDate;
    @PropertyDefinition(validate="notNull")
    private final LocalDate endDate;
    @PropertyDefinition(validate="notNull")
    private final Frequency frequency;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment businessDayAdjustment;
    @PropertyDefinition(get="optional")
    private final BusinessDayAdjustment startDateBusinessDayAdjustment;
    @PropertyDefinition(get="optional")
    private final BusinessDayAdjustment endDateBusinessDayAdjustment;
    @PropertyDefinition(get="optional")
    private final StubConvention stubConvention;
    @PropertyDefinition(get="optional")
    private final RollConvention rollConvention;
    @PropertyDefinition(get="optional")
    private final LocalDate firstRegularStartDate;
    @PropertyDefinition(get="optional")
    private final LocalDate lastRegularEndDate;
    @PropertyDefinition(get="optional")
    private final AdjustableDate overrideStartDate;
    private static final long serialVersionUID = 1L;

    public static PeriodicSchedule of(LocalDate unadjustedStartDate, LocalDate unadjustedEndDate, Frequency frequency, BusinessDayAdjustment businessDayAdjustment, StubConvention stubConvention, boolean preferEndOfMonth) {
        ArgChecker.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
        ArgChecker.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
        ArgChecker.notNull((Object)frequency, (String)"frequency");
        ArgChecker.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        ArgChecker.notNull((Object)((Object)stubConvention), (String)"stubConvention");
        return PeriodicSchedule.builder().startDate(unadjustedStartDate).endDate(unadjustedEndDate).frequency(frequency).businessDayAdjustment(businessDayAdjustment).stubConvention(stubConvention).rollConvention(preferEndOfMonth ? RollConventions.EOM : null).build();
    }

    public static PeriodicSchedule of(LocalDate unadjustedStartDate, LocalDate unadjustedEndDate, Frequency frequency, BusinessDayAdjustment businessDayAdjustment, StubConvention stubConvention, RollConvention rollConvention) {
        ArgChecker.notNull((Object)unadjustedStartDate, (String)"unadjustedStartDate");
        ArgChecker.notNull((Object)unadjustedEndDate, (String)"unadjustedEndDate");
        ArgChecker.notNull((Object)frequency, (String)"frequency");
        ArgChecker.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        ArgChecker.notNull((Object)((Object)stubConvention), (String)"stubConvention");
        ArgChecker.notNull((Object)rollConvention, (String)"rollConvention");
        return PeriodicSchedule.builder().startDate(unadjustedStartDate).endDate(unadjustedEndDate).frequency(frequency).businessDayAdjustment(businessDayAdjustment).stubConvention(stubConvention).rollConvention(rollConvention).build();
    }

    private void validate() {
        ArgChecker.inOrderNotEqual((Comparable)this.startDate, (Object)this.endDate, (String)"startDate", (String)"endDate");
        if (this.firstRegularStartDate != null) {
            ArgChecker.inOrderOrEqual((Comparable)this.startDate, (Object)this.firstRegularStartDate, (String)"unadjusted", (String)"firstRegularStartDate");
            if (this.lastRegularEndDate != null) {
                ArgChecker.inOrderNotEqual((Comparable)this.firstRegularStartDate, (Object)this.lastRegularEndDate, (String)"firstRegularStartDate", (String)"lastRegularEndDate");
            }
            if (this.overrideStartDate != null) {
                ArgChecker.inOrderNotEqual((Comparable)this.overrideStartDate.getUnadjusted(), (Object)this.firstRegularStartDate, (String)"overrideStartDate", (String)"firstRegularStartDate");
            }
        }
        if (this.lastRegularEndDate != null) {
            ArgChecker.inOrderOrEqual((Comparable)this.lastRegularEndDate, (Object)this.endDate, (String)"lastRegularEndDate", (String)"endDate");
        }
    }

    public Schedule createSchedule(ReferenceData refData) {
        LocalDate unadjStart = this.calculatedUnadjustedStartDate(refData);
        LocalDate unadjEnd = this.calculatedUnadjustedEndDate(refData);
        LocalDate regularStart = this.calculatedFirstRegularStartDate(unadjStart, refData);
        LocalDate regularEnd = this.calculatedLastRegularEndDate(unadjEnd, refData);
        RollConvention rollConv = this.calculatedRollConvention(regularStart, regularEnd);
        List<LocalDate> unadj = this.generateUnadjustedDates(unadjStart, regularStart, regularEnd, unadjEnd, rollConv);
        List<LocalDate> adj = this.applyBusinessDayAdjustment(unadj, refData);
        ArrayList<SchedulePeriod> periods = new ArrayList<SchedulePeriod>();
        try {
            for (int i = 0; i < unadj.size() - 1; ++i) {
                periods.add(SchedulePeriod.of(adj.get(i), adj.get(i + 1), unadj.get(i), unadj.get(i + 1)));
            }
        }
        catch (IllegalArgumentException ex) {
            this.createUnadjustedDates();
            this.createAdjustedDates(refData);
            ScheduleException se = new ScheduleException(this, "Schedule calculation resulted in invalid period", new Object[0]);
            se.initCause(ex);
            throw se;
        }
        return Schedule.builder().periods(periods).frequency(this.frequency).rollConvention(rollConv).build();
    }

    public ImmutableList<LocalDate> createUnadjustedDates() {
        RollConvention rollConv;
        LocalDate regularEnd;
        LocalDate regularStart = this.calculatedFirstRegularStartDate();
        List<LocalDate> unadj = this.generateUnadjustedDates(this.startDate, regularStart, regularEnd = this.calculatedLastRegularEndDate(), this.endDate, rollConv = this.calculatedRollConvention(regularStart, regularEnd));
        ImmutableList deduplicated = ImmutableSet.copyOf(unadj).asList();
        if (deduplicated.size() < unadj.size()) {
            throw new ScheduleException(this, "Schedule calculation resulted in duplicate unadjusted dates {}", unadj);
        }
        return deduplicated;
    }

    public ImmutableList<LocalDate> createUnadjustedDates(ReferenceData refData) {
        RollConvention rollConv;
        LocalDate regularEnd;
        LocalDate unadjStart = this.calculatedUnadjustedStartDate(refData);
        LocalDate unadjEnd = this.calculatedUnadjustedEndDate(refData);
        LocalDate regularStart = this.calculatedFirstRegularStartDate(unadjStart, refData);
        List<LocalDate> unadj = this.generateUnadjustedDates(unadjStart, regularStart, regularEnd = this.calculatedLastRegularEndDate(unadjEnd, refData), unadjEnd, rollConv = this.calculatedRollConvention(regularStart, regularEnd));
        ImmutableList deduplicated = ImmutableSet.copyOf(unadj).asList();
        if (deduplicated.size() < unadj.size()) {
            throw new ScheduleException(this, "Schedule calculation resulted in duplicate unadjusted dates {}", unadj);
        }
        return deduplicated;
    }

    private List<LocalDate> generateUnadjustedDates(LocalDate start, LocalDate regStart, LocalDate regEnd, LocalDate end, RollConvention rollConv) {
        boolean explicitFinalStub;
        LocalDate overrideStart = this.overrideStartDate != null ? this.overrideStartDate.getUnadjusted() : start;
        boolean explicitInitStub = !start.equals(regStart);
        boolean bl = explicitFinalStub = !end.equals(regEnd);
        if (regStart.equals(end) || regEnd.equals(start)) {
            return ImmutableList.of((Object)overrideStart, (Object)end);
        }
        if (this.frequency == Frequency.TERM) {
            if (explicitInitStub || explicitFinalStub) {
                throw new ScheduleException(this, "Explict stubs must not be specified when using 'Term' frequency", new Object[0]);
            }
            return ImmutableList.of((Object)overrideStart, (Object)end);
        }
        StubConvention stubConv = this.generateImplicitStubConvention(explicitInitStub, explicitFinalStub);
        if (this.overrideStartDate != null && this.rollConvention != null && this.firstRegularStartDate == null && !rollConv.matches(regStart) && rollConv.matches(overrideStart)) {
            return this.generateUnadjustedDates(overrideStart, regEnd, rollConv, stubConv, explicitInitStub, overrideStart, explicitFinalStub, end);
        }
        return this.generateUnadjustedDates(regStart, regEnd, rollConv, stubConv, explicitInitStub, overrideStart, explicitFinalStub, end);
    }

    private StubConvention generateImplicitStubConvention(boolean explicitInitialStub, boolean explicitFinalStub) {
        if (this.stubConvention != null) {
            return this.stubConvention.toImplicit(this, explicitInitialStub, explicitFinalStub);
        }
        return StubConvention.NONE;
    }

    private List<LocalDate> generateUnadjustedDates(LocalDate regStart, LocalDate regEnd, RollConvention rollConv, StubConvention stubConv, boolean explicitInitStub, LocalDate overrideStart, boolean explicitFinalStub, LocalDate end) {
        if (stubConv.isCalculateBackwards()) {
            return PeriodicSchedule.generateBackwards(this, regStart, regEnd, this.frequency, rollConv, stubConv, explicitInitStub, overrideStart, explicitFinalStub, end);
        }
        return PeriodicSchedule.generateForwards(this, regStart, regEnd, this.frequency, rollConv, stubConv, explicitInitStub, overrideStart, explicitFinalStub, end);
    }

    private static List<LocalDate> generateBackwards(PeriodicSchedule schedule, LocalDate start, LocalDate end, Frequency frequency, RollConvention rollConv, StubConvention stubConv, boolean explicitInitialStub, LocalDate explicitStartDate, boolean explicitFinalStub, LocalDate explicitEndDate) {
        boolean stub;
        if (!rollConv.matches(end)) {
            throw new ScheduleException(schedule, "Date '{}' does not match roll convention '{}' when starting to roll backwards", end, rollConv);
        }
        BackwardsList dates = new BackwardsList(PeriodicSchedule.estimateNumberPeriods(start, end, frequency));
        if (explicitFinalStub) {
            dates.addFirst(explicitEndDate);
        }
        dates.addFirst(end);
        LocalDate temp = rollConv.previous(end, frequency);
        while (temp.isAfter(start)) {
            dates.addFirst(temp);
            temp = rollConv.previous(temp, frequency);
        }
        boolean bl = stub = !temp.equals(start);
        if (stub && stubConv.isLong() && dates.size() > 1) {
            dates.removeFirst();
        }
        if (explicitInitialStub) {
            dates.addFirst(start);
            dates.addFirst(explicitStartDate);
        } else {
            dates.addFirst(explicitStartDate);
        }
        return dates;
    }

    private static List<LocalDate> generateForwards(PeriodicSchedule schedule, LocalDate start, LocalDate end, Frequency frequency, RollConvention rollConv, StubConvention stubConv, boolean explicitInitialStub, LocalDate explicitStartDate, boolean explicitFinalStub, LocalDate explicitEndDate) {
        boolean stub;
        if (!rollConv.matches(start)) {
            throw new ScheduleException(schedule, "Date '{}' does not match roll convention '{}' when starting to roll forwards", start, rollConv);
        }
        ArrayList<LocalDate> dates = new ArrayList<LocalDate>(PeriodicSchedule.estimateNumberPeriods(start, end, frequency));
        if (explicitInitialStub) {
            dates.add(explicitStartDate);
            dates.add(start);
        } else {
            dates.add(explicitStartDate);
        }
        LocalDate temp = rollConv.next(start, frequency);
        while (temp.isBefore(end)) {
            dates.add(temp);
            temp = rollConv.next(temp, frequency);
        }
        boolean bl = stub = !temp.equals(end);
        if (stub && dates.size() > 1) {
            if (stubConv == StubConvention.NONE) {
                throw new ScheduleException(schedule, "Period '{}' to '{}' resulted in a disallowed stub with frequency '{}'", start, end, frequency);
            }
            if (stubConv.isLong()) {
                dates.remove(dates.size() - 1);
            }
        }
        dates.add(end);
        if (explicitFinalStub) {
            dates.add(explicitEndDate);
        }
        return dates;
    }

    private static int estimateNumberPeriods(LocalDate start, LocalDate end, Frequency frequency) {
        int termInYearsEstimate = end.getYear() - start.getYear() + 2;
        return (int)(Math.max(frequency.eventsPerYearEstimate(), 1.0) * (double)termInYearsEstimate);
    }

    public ImmutableList<LocalDate> createAdjustedDates(ReferenceData refData) {
        RollConvention rollConv;
        LocalDate regularEnd;
        LocalDate unadjStart = this.calculatedUnadjustedStartDate(refData);
        LocalDate unadjEnd = this.calculatedUnadjustedEndDate(refData);
        LocalDate regularStart = this.calculatedFirstRegularStartDate(unadjStart, refData);
        List<LocalDate> unadj = this.generateUnadjustedDates(unadjStart, regularStart, regularEnd = this.calculatedLastRegularEndDate(unadjEnd, refData), unadjEnd, rollConv = this.calculatedRollConvention(regularStart, regularEnd));
        List<LocalDate> adj = this.applyBusinessDayAdjustment(unadj, refData);
        ImmutableList deduplicated = ImmutableSet.copyOf(adj).asList();
        if (deduplicated.size() < adj.size()) {
            throw new ScheduleException(this, "Schedule calculation resulted in duplicate adjusted dates {} from unadjusted dates {} using adjustment '{}'", adj, unadj, this.businessDayAdjustment);
        }
        return deduplicated;
    }

    private List<LocalDate> applyBusinessDayAdjustment(List<LocalDate> unadj, ReferenceData refData) {
        ArrayList<LocalDate> adj = new ArrayList<LocalDate>(unadj.size());
        adj.add(this.calculatedStartDate().adjusted(refData));
        for (int i = 1; i < unadj.size() - 1; ++i) {
            adj.add(this.businessDayAdjustment.adjust(unadj.get(i), refData));
        }
        adj.add(this.calculatedEndDate().adjusted(refData));
        return adj;
    }

    public RollConvention calculatedRollConvention() {
        return this.calculatedRollConvention(this.calculatedFirstRegularStartDate(), this.calculatedLastRegularEndDate());
    }

    private RollConvention calculatedRollConvention(LocalDate calculatedFirstRegStartDate, LocalDate calculatedLastRegEndDate) {
        StubConvention stubConv = (StubConvention)((Object)MoreObjects.firstNonNull((Object)((Object)this.stubConvention), (Object)((Object)StubConvention.NONE)));
        if (this.rollConvention == RollConventions.EOM) {
            RollConvention derived = stubConv.toRollConvention(calculatedFirstRegStartDate, calculatedLastRegEndDate, this.frequency, true);
            return derived == RollConventions.NONE ? RollConventions.EOM : derived;
        }
        if (this.rollConvention == null || this.rollConvention == RollConventions.NONE) {
            return stubConv.toRollConvention(calculatedFirstRegStartDate, calculatedLastRegEndDate, this.frequency, false);
        }
        return (RollConvention)MoreObjects.firstNonNull((Object)this.rollConvention, (Object)RollConventions.NONE);
    }

    private LocalDate calculatedUnadjustedStartDate(ReferenceData refData) {
        if (refData != null && this.rollConvention != null && BusinessDayAdjustment.NONE.equals(this.startDateBusinessDayAdjustment)) {
            return PeriodicSchedule.calculatedUnadjustedDateFromAdjusted(this.startDate, this.rollConvention, this.businessDayAdjustment, refData);
        }
        return this.startDate;
    }

    private LocalDate calculatedUnadjustedEndDate(ReferenceData refData) {
        if (refData != null && this.rollConvention != null) {
            return PeriodicSchedule.calculatedUnadjustedDateFromAdjusted(this.endDate, this.rollConvention, this.calculatedEndDateBusinessDayAdjustment(), refData);
        }
        return this.endDate;
    }

    private static LocalDate calculatedUnadjustedDateFromAdjusted(LocalDate baseDate, RollConvention rollConvention, BusinessDayAdjustment businessDayAdjustment, ReferenceData refData) {
        LocalDate adjDate;
        LocalDate rollImpliedDate;
        int rollDom = rollConvention.getDayOfMonth();
        if (rollDom > 0 && baseDate.getDayOfMonth() != rollDom) {
            LocalDate rollImpliedDate2;
            LocalDate adjDate2;
            int lengthOfMonth = baseDate.lengthOfMonth();
            int actualDom = Math.min(rollDom, lengthOfMonth);
            if (baseDate.getDayOfMonth() != actualDom && (adjDate2 = businessDayAdjustment.adjust(rollImpliedDate2 = baseDate.withDayOfMonth(actualDom), refData)).equals(baseDate)) {
                return rollImpliedDate2;
            }
        } else if (rollDom == 0 && !(rollImpliedDate = rollConvention.adjust(baseDate)).equals(baseDate) && (adjDate = businessDayAdjustment.adjust(rollImpliedDate, refData)).equals(baseDate)) {
            return rollImpliedDate;
        }
        return baseDate;
    }

    public LocalDate calculatedFirstRegularStartDate() {
        return (LocalDate)MoreObjects.firstNonNull((Object)this.firstRegularStartDate, (Object)this.startDate);
    }

    private LocalDate calculatedFirstRegularStartDate(LocalDate unadjStart, ReferenceData refData) {
        if (this.firstRegularStartDate == null) {
            return unadjStart;
        }
        if (refData != null && this.rollConvention != null) {
            return PeriodicSchedule.calculatedUnadjustedDateFromAdjusted(this.firstRegularStartDate, this.rollConvention, this.businessDayAdjustment, refData);
        }
        return this.firstRegularStartDate;
    }

    public LocalDate calculatedLastRegularEndDate() {
        return (LocalDate)MoreObjects.firstNonNull((Object)this.lastRegularEndDate, (Object)this.endDate);
    }

    private LocalDate calculatedLastRegularEndDate(LocalDate unadjEnd, ReferenceData refData) {
        if (this.lastRegularEndDate == null) {
            return unadjEnd;
        }
        if (refData != null && this.rollConvention != null) {
            return PeriodicSchedule.calculatedUnadjustedDateFromAdjusted(this.lastRegularEndDate, this.rollConvention, this.businessDayAdjustment, refData);
        }
        return this.lastRegularEndDate;
    }

    private BusinessDayAdjustment calculatedStartDateBusinessDayAdjustment() {
        return (BusinessDayAdjustment)MoreObjects.firstNonNull((Object)this.startDateBusinessDayAdjustment, (Object)this.businessDayAdjustment);
    }

    private BusinessDayAdjustment calculatedEndDateBusinessDayAdjustment() {
        return (BusinessDayAdjustment)MoreObjects.firstNonNull((Object)this.endDateBusinessDayAdjustment, (Object)this.businessDayAdjustment);
    }

    public AdjustableDate calculatedStartDate() {
        if (this.overrideStartDate != null) {
            return this.overrideStartDate;
        }
        return AdjustableDate.of(this.startDate, this.calculatedStartDateBusinessDayAdjustment());
    }

    public AdjustableDate calculatedEndDate() {
        return AdjustableDate.of(this.endDate, this.calculatedEndDateBusinessDayAdjustment());
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    public static Builder builder() {
        return new Builder();
    }

    private PeriodicSchedule(LocalDate startDate, LocalDate endDate, Frequency frequency, BusinessDayAdjustment businessDayAdjustment, BusinessDayAdjustment startDateBusinessDayAdjustment, BusinessDayAdjustment endDateBusinessDayAdjustment, StubConvention stubConvention, RollConvention rollConvention, LocalDate firstRegularStartDate, LocalDate lastRegularEndDate, AdjustableDate overrideStartDate) {
        JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
        JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
        JodaBeanUtils.notNull((Object)frequency, (String)"frequency");
        JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
        this.startDate = startDate;
        this.endDate = endDate;
        this.frequency = frequency;
        this.businessDayAdjustment = businessDayAdjustment;
        this.startDateBusinessDayAdjustment = startDateBusinessDayAdjustment;
        this.endDateBusinessDayAdjustment = endDateBusinessDayAdjustment;
        this.stubConvention = stubConvention;
        this.rollConvention = rollConvention;
        this.firstRegularStartDate = firstRegularStartDate;
        this.lastRegularEndDate = lastRegularEndDate;
        this.overrideStartDate = overrideStartDate;
        this.validate();
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public LocalDate getEndDate() {
        return this.endDate;
    }

    public Frequency getFrequency() {
        return this.frequency;
    }

    public BusinessDayAdjustment getBusinessDayAdjustment() {
        return this.businessDayAdjustment;
    }

    public Optional<BusinessDayAdjustment> getStartDateBusinessDayAdjustment() {
        return Optional.ofNullable(this.startDateBusinessDayAdjustment);
    }

    public Optional<BusinessDayAdjustment> getEndDateBusinessDayAdjustment() {
        return Optional.ofNullable(this.endDateBusinessDayAdjustment);
    }

    public Optional<StubConvention> getStubConvention() {
        return Optional.ofNullable(this.stubConvention);
    }

    public Optional<RollConvention> getRollConvention() {
        return Optional.ofNullable(this.rollConvention);
    }

    public Optional<LocalDate> getFirstRegularStartDate() {
        return Optional.ofNullable(this.firstRegularStartDate);
    }

    public Optional<LocalDate> getLastRegularEndDate() {
        return Optional.ofNullable(this.lastRegularEndDate);
    }

    public Optional<AdjustableDate> getOverrideStartDate() {
        return Optional.ofNullable(this.overrideStartDate);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            PeriodicSchedule other = (PeriodicSchedule)obj;
            return JodaBeanUtils.equal((Object)this.startDate, (Object)other.startDate) && JodaBeanUtils.equal((Object)this.endDate, (Object)other.endDate) && JodaBeanUtils.equal((Object)this.frequency, (Object)other.frequency) && JodaBeanUtils.equal((Object)this.businessDayAdjustment, (Object)other.businessDayAdjustment) && JodaBeanUtils.equal((Object)this.startDateBusinessDayAdjustment, (Object)other.startDateBusinessDayAdjustment) && JodaBeanUtils.equal((Object)this.endDateBusinessDayAdjustment, (Object)other.endDateBusinessDayAdjustment) && JodaBeanUtils.equal((Object)((Object)this.stubConvention), (Object)((Object)other.stubConvention)) && JodaBeanUtils.equal((Object)this.rollConvention, (Object)other.rollConvention) && JodaBeanUtils.equal((Object)this.firstRegularStartDate, (Object)other.firstRegularStartDate) && JodaBeanUtils.equal((Object)this.lastRegularEndDate, (Object)other.lastRegularEndDate) && JodaBeanUtils.equal((Object)this.overrideStartDate, (Object)other.overrideStartDate);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.frequency);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.businessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.startDateBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.endDateBusinessDayAdjustment);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)((Object)this.stubConvention));
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.rollConvention);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.firstRegularStartDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.lastRegularEndDate);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.overrideStartDate);
        return hash;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(384);
        buf.append("PeriodicSchedule{");
        buf.append("startDate").append('=').append(this.startDate).append(',').append(' ');
        buf.append("endDate").append('=').append(this.endDate).append(',').append(' ');
        buf.append("frequency").append('=').append(this.frequency).append(',').append(' ');
        buf.append("businessDayAdjustment").append('=').append(this.businessDayAdjustment).append(',').append(' ');
        buf.append("startDateBusinessDayAdjustment").append('=').append(this.startDateBusinessDayAdjustment).append(',').append(' ');
        buf.append("endDateBusinessDayAdjustment").append('=').append(this.endDateBusinessDayAdjustment).append(',').append(' ');
        buf.append("stubConvention").append('=').append((Object)this.stubConvention).append(',').append(' ');
        buf.append("rollConvention").append('=').append(this.rollConvention).append(',').append(' ');
        buf.append("firstRegularStartDate").append('=').append(this.firstRegularStartDate).append(',').append(' ');
        buf.append("lastRegularEndDate").append('=').append(this.lastRegularEndDate).append(',').append(' ');
        buf.append("overrideStartDate").append('=').append(JodaBeanUtils.toString((Object)this.overrideStartDate));
        buf.append('}');
        return buf.toString();
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    public static final class Builder
    extends DirectFieldsBeanBuilder<PeriodicSchedule> {
        private LocalDate startDate;
        private LocalDate endDate;
        private Frequency frequency;
        private BusinessDayAdjustment businessDayAdjustment;
        private BusinessDayAdjustment startDateBusinessDayAdjustment;
        private BusinessDayAdjustment endDateBusinessDayAdjustment;
        private StubConvention stubConvention;
        private RollConvention rollConvention;
        private LocalDate firstRegularStartDate;
        private LocalDate lastRegularEndDate;
        private AdjustableDate overrideStartDate;

        private Builder() {
        }

        private Builder(PeriodicSchedule beanToCopy) {
            this.startDate = beanToCopy.getStartDate();
            this.endDate = beanToCopy.getEndDate();
            this.frequency = beanToCopy.getFrequency();
            this.businessDayAdjustment = beanToCopy.getBusinessDayAdjustment();
            this.startDateBusinessDayAdjustment = beanToCopy.startDateBusinessDayAdjustment;
            this.endDateBusinessDayAdjustment = beanToCopy.endDateBusinessDayAdjustment;
            this.stubConvention = beanToCopy.stubConvention;
            this.rollConvention = beanToCopy.rollConvention;
            this.firstRegularStartDate = beanToCopy.firstRegularStartDate;
            this.lastRegularEndDate = beanToCopy.lastRegularEndDate;
            this.overrideStartDate = beanToCopy.overrideStartDate;
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -70023844: {
                    return this.frequency;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 429197561: {
                    return this.startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return this.endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return this.stubConvention;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 2011803076: {
                    return this.firstRegularStartDate;
                }
                case -1540679645: {
                    return this.lastRegularEndDate;
                }
                case -599936828: {
                    return this.overrideStartDate;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    this.startDate = (LocalDate)newValue;
                    break;
                }
                case -1607727319: {
                    this.endDate = (LocalDate)newValue;
                    break;
                }
                case -70023844: {
                    this.frequency = (Frequency)newValue;
                    break;
                }
                case -1065319863: {
                    this.businessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case 429197561: {
                    this.startDateBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -734327136: {
                    this.endDateBusinessDayAdjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                case -31408449: {
                    this.stubConvention = (StubConvention)((Object)newValue);
                    break;
                }
                case -10223666: {
                    this.rollConvention = (RollConvention)newValue;
                    break;
                }
                case 2011803076: {
                    this.firstRegularStartDate = (LocalDate)newValue;
                    break;
                }
                case -1540679645: {
                    this.lastRegularEndDate = (LocalDate)newValue;
                    break;
                }
                case -599936828: {
                    this.overrideStartDate = (AdjustableDate)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public Builder set(MetaProperty<?> property, Object value) {
            super.set(property, value);
            return this;
        }

        public PeriodicSchedule build() {
            return new PeriodicSchedule(this.startDate, this.endDate, this.frequency, this.businessDayAdjustment, this.startDateBusinessDayAdjustment, this.endDateBusinessDayAdjustment, this.stubConvention, this.rollConvention, this.firstRegularStartDate, this.lastRegularEndDate, this.overrideStartDate);
        }

        public Builder startDate(LocalDate startDate) {
            JodaBeanUtils.notNull((Object)startDate, (String)"startDate");
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(LocalDate endDate) {
            JodaBeanUtils.notNull((Object)endDate, (String)"endDate");
            this.endDate = endDate;
            return this;
        }

        public Builder frequency(Frequency frequency) {
            JodaBeanUtils.notNull((Object)frequency, (String)"frequency");
            this.frequency = frequency;
            return this;
        }

        public Builder businessDayAdjustment(BusinessDayAdjustment businessDayAdjustment) {
            JodaBeanUtils.notNull((Object)businessDayAdjustment, (String)"businessDayAdjustment");
            this.businessDayAdjustment = businessDayAdjustment;
            return this;
        }

        public Builder startDateBusinessDayAdjustment(BusinessDayAdjustment startDateBusinessDayAdjustment) {
            this.startDateBusinessDayAdjustment = startDateBusinessDayAdjustment;
            return this;
        }

        public Builder endDateBusinessDayAdjustment(BusinessDayAdjustment endDateBusinessDayAdjustment) {
            this.endDateBusinessDayAdjustment = endDateBusinessDayAdjustment;
            return this;
        }

        public Builder stubConvention(StubConvention stubConvention) {
            this.stubConvention = stubConvention;
            return this;
        }

        public Builder rollConvention(RollConvention rollConvention) {
            this.rollConvention = rollConvention;
            return this;
        }

        public Builder firstRegularStartDate(LocalDate firstRegularStartDate) {
            this.firstRegularStartDate = firstRegularStartDate;
            return this;
        }

        public Builder lastRegularEndDate(LocalDate lastRegularEndDate) {
            this.lastRegularEndDate = lastRegularEndDate;
            return this;
        }

        public Builder overrideStartDate(AdjustableDate overrideStartDate) {
            this.overrideStartDate = overrideStartDate;
            return this;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(384);
            buf.append("PeriodicSchedule.Builder{");
            buf.append("startDate").append('=').append(JodaBeanUtils.toString((Object)this.startDate)).append(',').append(' ');
            buf.append("endDate").append('=').append(JodaBeanUtils.toString((Object)this.endDate)).append(',').append(' ');
            buf.append("frequency").append('=').append(JodaBeanUtils.toString((Object)this.frequency)).append(',').append(' ');
            buf.append("businessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.businessDayAdjustment)).append(',').append(' ');
            buf.append("startDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.startDateBusinessDayAdjustment)).append(',').append(' ');
            buf.append("endDateBusinessDayAdjustment").append('=').append(JodaBeanUtils.toString((Object)this.endDateBusinessDayAdjustment)).append(',').append(' ');
            buf.append("stubConvention").append('=').append(JodaBeanUtils.toString((Object)((Object)this.stubConvention))).append(',').append(' ');
            buf.append("rollConvention").append('=').append(JodaBeanUtils.toString((Object)this.rollConvention)).append(',').append(' ');
            buf.append("firstRegularStartDate").append('=').append(JodaBeanUtils.toString((Object)this.firstRegularStartDate)).append(',').append(' ');
            buf.append("lastRegularEndDate").append('=').append(JodaBeanUtils.toString((Object)this.lastRegularEndDate)).append(',').append(' ');
            buf.append("overrideStartDate").append('=').append(JodaBeanUtils.toString((Object)this.overrideStartDate));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> startDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDate", PeriodicSchedule.class, LocalDate.class);
        private final MetaProperty<LocalDate> endDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDate", PeriodicSchedule.class, LocalDate.class);
        private final MetaProperty<Frequency> frequency = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"frequency", PeriodicSchedule.class, Frequency.class);
        private final MetaProperty<BusinessDayAdjustment> businessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"businessDayAdjustment", PeriodicSchedule.class, BusinessDayAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> startDateBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"startDateBusinessDayAdjustment", PeriodicSchedule.class, BusinessDayAdjustment.class);
        private final MetaProperty<BusinessDayAdjustment> endDateBusinessDayAdjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"endDateBusinessDayAdjustment", PeriodicSchedule.class, BusinessDayAdjustment.class);
        private final MetaProperty<StubConvention> stubConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"stubConvention", PeriodicSchedule.class, StubConvention.class);
        private final MetaProperty<RollConvention> rollConvention = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"rollConvention", PeriodicSchedule.class, RollConvention.class);
        private final MetaProperty<LocalDate> firstRegularStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"firstRegularStartDate", PeriodicSchedule.class, LocalDate.class);
        private final MetaProperty<LocalDate> lastRegularEndDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"lastRegularEndDate", PeriodicSchedule.class, LocalDate.class);
        private final MetaProperty<AdjustableDate> overrideStartDate = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"overrideStartDate", PeriodicSchedule.class, AdjustableDate.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"startDate", "endDate", "frequency", "businessDayAdjustment", "startDateBusinessDayAdjustment", "endDateBusinessDayAdjustment", "stubConvention", "rollConvention", "firstRegularStartDate", "lastRegularEndDate", "overrideStartDate"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return this.startDate;
                }
                case -1607727319: {
                    return this.endDate;
                }
                case -70023844: {
                    return this.frequency;
                }
                case -1065319863: {
                    return this.businessDayAdjustment;
                }
                case 429197561: {
                    return this.startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return this.endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return this.stubConvention;
                }
                case -10223666: {
                    return this.rollConvention;
                }
                case 2011803076: {
                    return this.firstRegularStartDate;
                }
                case -1540679645: {
                    return this.lastRegularEndDate;
                }
                case -599936828: {
                    return this.overrideStartDate;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public Builder builder() {
            return new Builder();
        }

        public Class<? extends PeriodicSchedule> beanType() {
            return PeriodicSchedule.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> startDate() {
            return this.startDate;
        }

        public MetaProperty<LocalDate> endDate() {
            return this.endDate;
        }

        public MetaProperty<Frequency> frequency() {
            return this.frequency;
        }

        public MetaProperty<BusinessDayAdjustment> businessDayAdjustment() {
            return this.businessDayAdjustment;
        }

        public MetaProperty<BusinessDayAdjustment> startDateBusinessDayAdjustment() {
            return this.startDateBusinessDayAdjustment;
        }

        public MetaProperty<BusinessDayAdjustment> endDateBusinessDayAdjustment() {
            return this.endDateBusinessDayAdjustment;
        }

        public MetaProperty<StubConvention> stubConvention() {
            return this.stubConvention;
        }

        public MetaProperty<RollConvention> rollConvention() {
            return this.rollConvention;
        }

        public MetaProperty<LocalDate> firstRegularStartDate() {
            return this.firstRegularStartDate;
        }

        public MetaProperty<LocalDate> lastRegularEndDate() {
            return this.lastRegularEndDate;
        }

        public MetaProperty<AdjustableDate> overrideStartDate() {
            return this.overrideStartDate;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case -2129778896: {
                    return ((PeriodicSchedule)bean).getStartDate();
                }
                case -1607727319: {
                    return ((PeriodicSchedule)bean).getEndDate();
                }
                case -70023844: {
                    return ((PeriodicSchedule)bean).getFrequency();
                }
                case -1065319863: {
                    return ((PeriodicSchedule)bean).getBusinessDayAdjustment();
                }
                case 429197561: {
                    return ((PeriodicSchedule)bean).startDateBusinessDayAdjustment;
                }
                case -734327136: {
                    return ((PeriodicSchedule)bean).endDateBusinessDayAdjustment;
                }
                case -31408449: {
                    return ((PeriodicSchedule)bean).stubConvention;
                }
                case -10223666: {
                    return ((PeriodicSchedule)bean).rollConvention;
                }
                case 2011803076: {
                    return ((PeriodicSchedule)bean).firstRegularStartDate;
                }
                case -1540679645: {
                    return ((PeriodicSchedule)bean).lastRegularEndDate;
                }
                case -599936828: {
                    return ((PeriodicSchedule)bean).overrideStartDate;
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }

    private static class BackwardsList
    extends AbstractList<LocalDate> {
        private int first;
        private LocalDate[] array;

        BackwardsList(int capacity) {
            this.array = new LocalDate[capacity];
            this.first = this.array.length;
        }

        @Override
        public LocalDate get(int index) {
            return this.array[this.first + index];
        }

        @Override
        public int size() {
            return this.array.length - this.first;
        }

        @Override
        void addFirst(LocalDate date) {
            this.array[--this.first] = date;
        }

        @Override
        void removeFirst() {
            ++this.first;
        }
    }
}

