# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['Observable']


class Observable(BaseDataClass):
    """
    Specifies the object to be observed for a price, it could be an asset or a reference.
    """
    rateOption: Optional[AttributeWithMeta[cdm.observable.asset.FloatingRateOption.FloatingRateOption] | cdm.observable.asset.FloatingRateOption.FloatingRateOption] = Field(None, description="Specifies a floating rate index and tenor.")
    """
    Specifies a floating rate index and tenor.
    """
    commodity: Optional[AttributeWithMeta[cdm.base.staticdata.asset.common.Commodity.Commodity] | cdm.base.staticdata.asset.common.Commodity.Commodity] = Field(None, description="Identifies a commodity by referencing a product identifier.")
    """
    Identifies a commodity by referencing a product identifier.
    """
    productIdentifier: List[AttributeWithMeta[cdm.base.staticdata.asset.common.ProductIdentifier.ProductIdentifier] | cdm.base.staticdata.asset.common.ProductIdentifier.ProductIdentifier] = Field([], description="Comprises of an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the ProductIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.")
    """
    Comprises of an identifier and a source. The associated metadata key denotes the ability to associate a hash value to the ProductIdentifier instantiations for the purpose of model cross-referencing, in support of functionality such as the event effect and the lineage.
    """
    currencyPair: Optional[AttributeWithMeta[cdm.observable.asset.QuotedCurrencyPair.QuotedCurrencyPair] | cdm.observable.asset.QuotedCurrencyPair.QuotedCurrencyPair] = Field(None, description="Describes the composition of a rate that has been quoted or is to be quoted, including the two currencies and the quotation relationship between the two currencies.")
    """
    Describes the composition of a rate that has been quoted or is to be quoted, including the two currencies and the quotation relationship between the two currencies.
    """
    optionReferenceType: Optional[cdm.observable.asset.OptionReferenceTypeEnum.OptionReferenceTypeEnum] = Field(None, description="The underlying contract which is referenced when determining the final settlement price of the instrument. Eg. Rolling Front Month Future; Spot etc.")
    """
    The underlying contract which is referenced when determining the final settlement price of the instrument. Eg. Rolling Front Month Future; Spot etc.
    """
    
    @rosetta_condition
    def condition_0_ObservableChoice(self):
        """
        An observable can only be composed of one type any time.
        """
        item = self
        return rosetta_check_one_of(self, 'rateOption', 'commodity', 'productIdentifier', 'currencyPair', necessity=True)

import cdm 
import cdm.observable.asset.FloatingRateOption
import cdm.base.staticdata.asset.common.Commodity
import cdm.base.staticdata.asset.common.ProductIdentifier
import cdm.observable.asset.QuotedCurrencyPair
import cdm.observable.asset.OptionReferenceTypeEnum
