# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['SecurityValuationModel']


class SecurityValuationModel(BaseDataClass):
    """
     The security valuation model choice, which can either be based on nominal amount as for a bond, or on the number of contract units as for equity.
    """
    bondValuationModel: Optional[cdm.observable.asset.BondValuationModel.BondValuationModel] = Field(None, description="The valuation model when the security is a bond.")
    """
    The valuation model when the security is a bond.
    """
    unitContractValuationModel: Optional[cdm.observable.asset.UnitContractValuationModel.UnitContractValuationModel] = Field(None, description="The valuation model when the security is a unit contract like equity.")
    """
    The valuation model when the security is a unit contract like equity.
    """
    
    @rosetta_condition
    def condition_0_(self):
        item = self
        return rosetta_check_one_of(self, 'bondValuationModel', 'unitContractValuationModel', necessity=True)

import cdm 
import cdm.observable.asset.BondValuationModel
import cdm.observable.asset.UnitContractValuationModel
