# pylint: disable=line-too-long, invalid-name, missing-function-docstring, missing-module-docstring, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import, wildcard-import, wrong-import-order, missing-class-docstring
from __future__ import annotations
import sys
import datetime
import inspect
from decimal import Decimal
from rosetta.runtime.utils import *
from rosetta.runtime.func_proxy import replaceable, create_module_attr_guardian
from cdm.base.math.functions.UnitEquals import UnitEquals
from cdm.observable.asset.PriceSchedule import PriceSchedule

__all__ = ['PriceUnitEquals']


@replaceable
def PriceUnitEquals(p1: PriceSchedule | None, p2: PriceSchedule | None) -> bool:
    """
    Compares two PriceSchedule to check if all attributes match, except for the amount.
    
    Parameters 
    ----------
    p1 : PriceSchedule
    
    p2 : PriceSchedule
    
    Returns
    -------
    result : boolean
    
    """
    self = inspect.currentframe()
    
    
    unitMatches = UnitEquals(rosetta_resolve_attr(rosetta_resolve_attr(self, "p1"), "unit"), rosetta_resolve_attr(rosetta_resolve_attr(self, "p2"), "unit"))
    perUnitOfMatches = UnitEquals(rosetta_resolve_attr(rosetta_resolve_attr(self, "p1"), "perUnitOf"), rosetta_resolve_attr(rosetta_resolve_attr(self, "p2"), "perUnitOf"))
    priceTypeMatches = (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "p1"), "priceType"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "p2"), "priceType")))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "p1"), "priceType"), "=", rosetta_resolve_attr(rosetta_resolve_attr(self, "p2"), "priceType")))
    priceExpressionMatches = (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "p1"), "priceExpression"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "p2"), "priceExpression")))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "p1"), "priceExpression"), "=", rosetta_resolve_attr(rosetta_resolve_attr(self, "p2"), "priceExpression")))
    arithmeticOperatorMatches = (((not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "p1"), "arithmeticOperator"))) and (not rosetta_attr_exists(rosetta_resolve_attr(rosetta_resolve_attr(self, "p2"), "arithmeticOperator")))) or all_elements(rosetta_resolve_attr(rosetta_resolve_attr(self, "p1"), "arithmeticOperator"), "=", rosetta_resolve_attr(rosetta_resolve_attr(self, "p2"), "arithmeticOperator")))
    result =  ((((rosetta_resolve_attr(self, "unitMatches") and rosetta_resolve_attr(self, "perUnitOfMatches")) and rosetta_resolve_attr(self, "priceTypeMatches")) and rosetta_resolve_attr(self, "priceExpressionMatches")) and rosetta_resolve_attr(self, "arithmeticOperatorMatches"))
    
    
    return result

sys.modules[__name__].__class__ = create_module_attr_guardian(sys.modules[__name__].__class__)
