# pylint: disable=line-too-long, invalid-name, missing-function-docstring
# pylint: disable=bad-indentation, trailing-whitespace, superfluous-parens
# pylint: disable=wrong-import-position, unused-import, unused-wildcard-import
# pylint: disable=wildcard-import, wrong-import-order, missing-class-docstring
# pylint: disable=missing-module-docstring
from __future__ import annotations
from typing import List, Optional
import datetime
import inspect
from decimal import Decimal
from pydantic import Field
from rosetta.runtime.utils import (
    BaseDataClass, rosetta_condition, rosetta_resolve_attr, rosetta_resolve_deep_attr
)
from rosetta.runtime.utils import *

__all__ = ['AssetLeg']


class AssetLeg(BaseDataClass):
    """
    Defines each asset movement of an asset payout.
    """
    settlementDate: cdm.base.datetime.AdjustableOrRelativeDate.AdjustableOrRelativeDate = Field(..., description="Specifies the settlement date of securities. In a repo transaction the purchase date would always be the effective date as specified under Economic Terms, the repurchase date would always be the termination date as specified under Economic Terms.")
    """
    Specifies the settlement date of securities.  In a repo transaction the purchase date would always be the effective date as specified under Economic Terms, the repurchase date would always be the termination date as specified under Economic Terms.
    """
    deliveryMethod: cdm.product.common.settlement.DeliveryMethodEnum.DeliveryMethodEnum = Field(..., description="Specifies a delivery method for the security transaction.")
    """
    Specifies a delivery method for the security transaction.
    """

import cdm 
import cdm.base.datetime.AdjustableOrRelativeDate
import cdm.product.common.settlement.DeliveryMethodEnum
