package iso20022.auth030.mas.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.mas.PriceData2__1;
import iso20022.auth030.mas.SecuritiesTransactionPrice17Choice__1;
import iso20022.auth030.mas.UnitOfMeasure8Choice__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class PriceData2__1Validator implements Validator<PriceData2__1> {

	private List<ComparisonResult> getComparisonResults(PriceData2__1 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("pric", (SecuritiesTransactionPrice17Choice__1) o.getPric() != null ? 1 : 0, 0, 1), 
				checkCardinality("unitOfMeasr", (UnitOfMeasure8Choice__1) o.getUnitOfMeasr() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceData2__1 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("PriceData2__1", ValidationResult.ValidationType.CARDINALITY, "PriceData2__1", path, "", res.getError());
				}
				return success("PriceData2__1", ValidationResult.ValidationType.CARDINALITY, "PriceData2__1", path, "");
			})
			.collect(toList());
	}

}
