package drr.base.trade.util;

import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.CommodityPayout;
import cdm.product.asset.CreditDefaultPayout;
import cdm.product.asset.InterestRatePayout;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.PrincipalPayments;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.template.FixedPricePayout;
import cdm.product.template.ForwardPayout;
import cdm.product.template.OptionPayout;
import cdm.product.template.PerformancePayout;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.PayoutLeg;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

public class PayoutLegDeepPathUtil {
	public PayerReceiver choosePayerReceiver(PayoutLeg payoutLeg) {
		final MapperS<CreditDefaultPayout> creditDefaultPayout = MapperS.of(payoutLeg).<CreditDefaultPayout>map("getCreditDefaultPayout", _payoutLeg -> _payoutLeg.getCreditDefaultPayout());
		if (exists(creditDefaultPayout).getOrDefault(false)) {
			return creditDefaultPayout.<PayerReceiver>map("getPayerReceiver", _creditDefaultPayout -> _creditDefaultPayout.getPayerReceiver()).get();
		}
		final MapperS<OptionPayout> optionPayout = MapperS.of(payoutLeg).<OptionPayout>map("getOptionPayout", _payoutLeg -> _payoutLeg.getOptionPayout());
		if (exists(optionPayout).getOrDefault(false)) {
			return optionPayout.<PayerReceiver>map("getPayerReceiver", _optionPayout -> _optionPayout.getPayerReceiver()).get();
		}
		final MapperS<ForwardPayout> forwardPayout = MapperS.of(payoutLeg).<ForwardPayout>map("getForwardPayout", _payoutLeg -> _payoutLeg.getForwardPayout());
		if (exists(forwardPayout).getOrDefault(false)) {
			return forwardPayout.<PayerReceiver>map("getPayerReceiver", _forwardPayout -> _forwardPayout.getPayerReceiver()).get();
		}
		final MapperS<PerformancePayout> performancePayout = MapperS.of(payoutLeg).<PerformancePayout>map("getPerformancePayout", _payoutLeg -> _payoutLeg.getPerformancePayout());
		if (exists(performancePayout).getOrDefault(false)) {
			return performancePayout.<PayerReceiver>map("getPayerReceiver", _performancePayout -> _performancePayout.getPayerReceiver()).get();
		}
		final MapperS<InterestRatePayout> interestRatePayout = MapperS.of(payoutLeg).<InterestRatePayout>map("getInterestRatePayout", _payoutLeg -> _payoutLeg.getInterestRatePayout());
		if (exists(interestRatePayout).getOrDefault(false)) {
			return interestRatePayout.<PayerReceiver>map("getPayerReceiver", _interestRatePayout -> _interestRatePayout.getPayerReceiver()).get();
		}
		final MapperS<Cashflow> cashflow = MapperS.of(payoutLeg).<Cashflow>map("getCashflow", _payoutLeg -> _payoutLeg.getCashflow());
		if (exists(cashflow).getOrDefault(false)) {
			return cashflow.<PayerReceiver>map("getPayerReceiver", _cashflow -> _cashflow.getPayerReceiver()).get();
		}
		final MapperS<FixedPricePayout> fixedPricePayout = MapperS.of(payoutLeg).<FixedPricePayout>map("getFixedPricePayout", _payoutLeg -> _payoutLeg.getFixedPricePayout());
		if (exists(fixedPricePayout).getOrDefault(false)) {
			return fixedPricePayout.<PayerReceiver>map("getPayerReceiver", _fixedPricePayout -> _fixedPricePayout.getPayerReceiver()).get();
		}
		final MapperS<CommodityPayout> commodityPayout = MapperS.of(payoutLeg).<CommodityPayout>map("getCommodityPayout", _payoutLeg -> _payoutLeg.getCommodityPayout());
		if (exists(commodityPayout).getOrDefault(false)) {
			return commodityPayout.<PayerReceiver>map("getPayerReceiver", _commodityPayout -> _commodityPayout.getPayerReceiver()).get();
		}
		return null;
	}
	
	public ResolvablePriceQuantity choosePriceQuantity(PayoutLeg payoutLeg) {
		final MapperS<CreditDefaultPayout> creditDefaultPayout = MapperS.of(payoutLeg).<CreditDefaultPayout>map("getCreditDefaultPayout", _payoutLeg -> _payoutLeg.getCreditDefaultPayout());
		if (exists(creditDefaultPayout).getOrDefault(false)) {
			return creditDefaultPayout.<ResolvablePriceQuantity>map("getPriceQuantity", _creditDefaultPayout -> _creditDefaultPayout.getPriceQuantity()).get();
		}
		final MapperS<OptionPayout> optionPayout = MapperS.of(payoutLeg).<OptionPayout>map("getOptionPayout", _payoutLeg -> _payoutLeg.getOptionPayout());
		if (exists(optionPayout).getOrDefault(false)) {
			return optionPayout.<ResolvablePriceQuantity>map("getPriceQuantity", _optionPayout -> _optionPayout.getPriceQuantity()).get();
		}
		final MapperS<ForwardPayout> forwardPayout = MapperS.of(payoutLeg).<ForwardPayout>map("getForwardPayout", _payoutLeg -> _payoutLeg.getForwardPayout());
		if (exists(forwardPayout).getOrDefault(false)) {
			return forwardPayout.<ResolvablePriceQuantity>map("getPriceQuantity", _forwardPayout -> _forwardPayout.getPriceQuantity()).get();
		}
		final MapperS<PerformancePayout> performancePayout = MapperS.of(payoutLeg).<PerformancePayout>map("getPerformancePayout", _payoutLeg -> _payoutLeg.getPerformancePayout());
		if (exists(performancePayout).getOrDefault(false)) {
			return performancePayout.<ResolvablePriceQuantity>map("getPriceQuantity", _performancePayout -> _performancePayout.getPriceQuantity()).get();
		}
		final MapperS<InterestRatePayout> interestRatePayout = MapperS.of(payoutLeg).<InterestRatePayout>map("getInterestRatePayout", _payoutLeg -> _payoutLeg.getInterestRatePayout());
		if (exists(interestRatePayout).getOrDefault(false)) {
			return interestRatePayout.<ResolvablePriceQuantity>map("getPriceQuantity", _interestRatePayout -> _interestRatePayout.getPriceQuantity()).get();
		}
		final MapperS<Cashflow> cashflow = MapperS.of(payoutLeg).<Cashflow>map("getCashflow", _payoutLeg -> _payoutLeg.getCashflow());
		if (exists(cashflow).getOrDefault(false)) {
			return cashflow.<ResolvablePriceQuantity>map("getPriceQuantity", _cashflow -> _cashflow.getPriceQuantity()).get();
		}
		final MapperS<FixedPricePayout> fixedPricePayout = MapperS.of(payoutLeg).<FixedPricePayout>map("getFixedPricePayout", _payoutLeg -> _payoutLeg.getFixedPricePayout());
		if (exists(fixedPricePayout).getOrDefault(false)) {
			return fixedPricePayout.<ResolvablePriceQuantity>map("getPriceQuantity", _fixedPricePayout -> _fixedPricePayout.getPriceQuantity()).get();
		}
		final MapperS<CommodityPayout> commodityPayout = MapperS.of(payoutLeg).<CommodityPayout>map("getCommodityPayout", _payoutLeg -> _payoutLeg.getCommodityPayout());
		if (exists(commodityPayout).getOrDefault(false)) {
			return commodityPayout.<ResolvablePriceQuantity>map("getPriceQuantity", _commodityPayout -> _commodityPayout.getPriceQuantity()).get();
		}
		return null;
	}
	
	public SettlementTerms chooseSettlementTerms(PayoutLeg payoutLeg) {
		final MapperS<CreditDefaultPayout> creditDefaultPayout = MapperS.of(payoutLeg).<CreditDefaultPayout>map("getCreditDefaultPayout", _payoutLeg -> _payoutLeg.getCreditDefaultPayout());
		if (exists(creditDefaultPayout).getOrDefault(false)) {
			return creditDefaultPayout.<SettlementTerms>map("getSettlementTerms", _creditDefaultPayout -> _creditDefaultPayout.getSettlementTerms()).get();
		}
		final MapperS<OptionPayout> optionPayout = MapperS.of(payoutLeg).<OptionPayout>map("getOptionPayout", _payoutLeg -> _payoutLeg.getOptionPayout());
		if (exists(optionPayout).getOrDefault(false)) {
			return optionPayout.<SettlementTerms>map("getSettlementTerms", _optionPayout -> _optionPayout.getSettlementTerms()).get();
		}
		final MapperS<ForwardPayout> forwardPayout = MapperS.of(payoutLeg).<ForwardPayout>map("getForwardPayout", _payoutLeg -> _payoutLeg.getForwardPayout());
		if (exists(forwardPayout).getOrDefault(false)) {
			return forwardPayout.<SettlementTerms>map("getSettlementTerms", _forwardPayout -> _forwardPayout.getSettlementTerms()).get();
		}
		final MapperS<PerformancePayout> performancePayout = MapperS.of(payoutLeg).<PerformancePayout>map("getPerformancePayout", _payoutLeg -> _payoutLeg.getPerformancePayout());
		if (exists(performancePayout).getOrDefault(false)) {
			return performancePayout.<SettlementTerms>map("getSettlementTerms", _performancePayout -> _performancePayout.getSettlementTerms()).get();
		}
		final MapperS<InterestRatePayout> interestRatePayout = MapperS.of(payoutLeg).<InterestRatePayout>map("getInterestRatePayout", _payoutLeg -> _payoutLeg.getInterestRatePayout());
		if (exists(interestRatePayout).getOrDefault(false)) {
			return interestRatePayout.<SettlementTerms>map("getSettlementTerms", _interestRatePayout -> _interestRatePayout.getSettlementTerms()).get();
		}
		final MapperS<Cashflow> cashflow = MapperS.of(payoutLeg).<Cashflow>map("getCashflow", _payoutLeg -> _payoutLeg.getCashflow());
		if (exists(cashflow).getOrDefault(false)) {
			return cashflow.<SettlementTerms>map("getSettlementTerms", _cashflow -> _cashflow.getSettlementTerms()).get();
		}
		final MapperS<FixedPricePayout> fixedPricePayout = MapperS.of(payoutLeg).<FixedPricePayout>map("getFixedPricePayout", _payoutLeg -> _payoutLeg.getFixedPricePayout());
		if (exists(fixedPricePayout).getOrDefault(false)) {
			return fixedPricePayout.<SettlementTerms>map("getSettlementTerms", _fixedPricePayout -> _fixedPricePayout.getSettlementTerms()).get();
		}
		final MapperS<CommodityPayout> commodityPayout = MapperS.of(payoutLeg).<CommodityPayout>map("getCommodityPayout", _payoutLeg -> _payoutLeg.getCommodityPayout());
		if (exists(commodityPayout).getOrDefault(false)) {
			return commodityPayout.<SettlementTerms>map("getSettlementTerms", _commodityPayout -> _commodityPayout.getSettlementTerms()).get();
		}
		return null;
	}
	
	public PrincipalPayments choosePrincipalPayment(PayoutLeg payoutLeg) {
		final MapperS<CreditDefaultPayout> creditDefaultPayout = MapperS.of(payoutLeg).<CreditDefaultPayout>map("getCreditDefaultPayout", _payoutLeg -> _payoutLeg.getCreditDefaultPayout());
		if (exists(creditDefaultPayout).getOrDefault(false)) {
			return creditDefaultPayout.<PrincipalPayments>map("getPrincipalPayment", _creditDefaultPayout -> _creditDefaultPayout.getPrincipalPayment()).get();
		}
		final MapperS<OptionPayout> optionPayout = MapperS.of(payoutLeg).<OptionPayout>map("getOptionPayout", _payoutLeg -> _payoutLeg.getOptionPayout());
		if (exists(optionPayout).getOrDefault(false)) {
			return optionPayout.<PrincipalPayments>map("getPrincipalPayment", _optionPayout -> _optionPayout.getPrincipalPayment()).get();
		}
		final MapperS<ForwardPayout> forwardPayout = MapperS.of(payoutLeg).<ForwardPayout>map("getForwardPayout", _payoutLeg -> _payoutLeg.getForwardPayout());
		if (exists(forwardPayout).getOrDefault(false)) {
			return forwardPayout.<PrincipalPayments>map("getPrincipalPayment", _forwardPayout -> _forwardPayout.getPrincipalPayment()).get();
		}
		final MapperS<PerformancePayout> performancePayout = MapperS.of(payoutLeg).<PerformancePayout>map("getPerformancePayout", _payoutLeg -> _payoutLeg.getPerformancePayout());
		if (exists(performancePayout).getOrDefault(false)) {
			return performancePayout.<PrincipalPayments>map("getPrincipalPayment", _performancePayout -> _performancePayout.getPrincipalPayment()).get();
		}
		final MapperS<InterestRatePayout> interestRatePayout = MapperS.of(payoutLeg).<InterestRatePayout>map("getInterestRatePayout", _payoutLeg -> _payoutLeg.getInterestRatePayout());
		if (exists(interestRatePayout).getOrDefault(false)) {
			return interestRatePayout.<PrincipalPayments>map("getPrincipalPayment", _interestRatePayout -> _interestRatePayout.getPrincipalPayment()).get();
		}
		final MapperS<Cashflow> cashflow = MapperS.of(payoutLeg).<Cashflow>map("getCashflow", _payoutLeg -> _payoutLeg.getCashflow());
		if (exists(cashflow).getOrDefault(false)) {
			return cashflow.<PrincipalPayments>map("getPrincipalPayment", _cashflow -> _cashflow.getPrincipalPayment()).get();
		}
		final MapperS<FixedPricePayout> fixedPricePayout = MapperS.of(payoutLeg).<FixedPricePayout>map("getFixedPricePayout", _payoutLeg -> _payoutLeg.getFixedPricePayout());
		if (exists(fixedPricePayout).getOrDefault(false)) {
			return fixedPricePayout.<PrincipalPayments>map("getPrincipalPayment", _fixedPricePayout -> _fixedPricePayout.getPrincipalPayment()).get();
		}
		final MapperS<CommodityPayout> commodityPayout = MapperS.of(payoutLeg).<CommodityPayout>map("getCommodityPayout", _payoutLeg -> _payoutLeg.getCommodityPayout());
		if (exists(commodityPayout).getOrDefault(false)) {
			return commodityPayout.<PrincipalPayments>map("getPrincipalPayment", _commodityPayout -> _commodityPayout.getPrincipalPayment()).get();
		}
		return null;
	}
	
}
