package drr.projection.dtcc.rds.harmonized.sec.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.base.trade.payment.OtherPayment;
import drr.base.trade.price.PriceFormat;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.dtcc.trade.UnderlyingAssetReport;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.sec.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import drr.standards.iso.PaymentType4Code;
import iso20022.dtcc.rds.harmonized.HarmonizedRepeatableData;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Create_SubmissionHarmonizedRepeatableData.Create_SubmissionHarmonizedRepeatableDataDefault.class)
public abstract class Create_SubmissionHarmonizedRepeatableData implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param drrReport 
	* @return harmonized 
	*/
	public HarmonizedRepeatableData evaluate(SECTransactionReport drrReport) {
		HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder harmonizedBuilder = doEvaluate(drrReport);
		
		final HarmonizedRepeatableData harmonized;
		if (harmonizedBuilder == null) {
			harmonized = null;
		} else {
			harmonized = harmonizedBuilder.build();
			objectValidator.validate(HarmonizedRepeatableData.class, harmonized);
		}
		
		return harmonized;
	}

	protected abstract HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder doEvaluate(SECTransactionReport drrReport);

	protected abstract MapperS<Boolean> needsUpfrontFee(SECTransactionReport drrReport);

	public static class Create_SubmissionHarmonizedRepeatableDataDefault extends Create_SubmissionHarmonizedRepeatableData {
		@Override
		protected HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder doEvaluate(SECTransactionReport drrReport) {
			HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder harmonized = HarmonizedRepeatableData.builder();
			return assignOutput(harmonized, drrReport);
		}
		
		protected HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder assignOutput(HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder harmonized, SECTransactionReport drrReport) {
			harmonized = toBuilder(HarmonizedRepeatableData.builder()
				.setUnderlyingAssetId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<UnderlyingAssetReport>mapC("getUnderlyingAsset", dTCCAdditionalFields -> dTCCAdditionalFields.getUnderlyingAsset()).<String>map("getUnderlyingAssetID", underlyingAssetReport -> underlyingAssetReport.getUnderlyingAssetID()).getMulti())
				.setUnderlyingAssetIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<UnderlyingAssetReport>mapC("getUnderlyingAsset", dTCCAdditionalFields -> dTCCAdditionalFields.getUnderlyingAsset()).<String>map("getUnderlyingAssetIDType", underlyingAssetReport -> underlyingAssetReport.getUnderlyingAssetIDType()).getMulti())
				.setUnderlyingAssetName(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<String>mapC("getUnderlyingAssetName", dTCCAdditionalFields -> dTCCAdditionalFields.getUnderlyingAssetName()).getMulti())
				.setCdeOtherPaymentPayer(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", sECTransactionReport -> sECTransactionReport.getOtherPayment()).<String>map("getPayer", otherPayment -> otherPayment.getPayer()).getMulti())
				.setCdeOtherPaymentReceiver(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", sECTransactionReport -> sECTransactionReport.getOtherPayment()).<String>map("getReceiver", otherPayment -> otherPayment.getReceiver()).getMulti())
				.setCdeOtherPaymentAmount(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", sECTransactionReport -> sECTransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPayment -> otherPayment.getAmount()).getMulti())
				.setCdeOtherPaymentCurrency(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", sECTransactionReport -> sECTransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPayment -> otherPayment.getCurrency())
					.mapItem(item -> item.map("to-string", ISOCurrencyCodeEnum::toDisplayString)).getMulti())
				.setCdeOtherPaymentDate(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", sECTransactionReport -> sECTransactionReport.getOtherPayment()).<Date>map("getDate", otherPayment -> otherPayment.getDate()).getMulti())
				.setCdeOtherPaymentType(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", sECTransactionReport -> sECTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPayment -> otherPayment.getPaymentType())
					.mapItem(item -> item.map("to-string", PaymentType4Code::toDisplayString)).getMulti())
				.setOtherPaymentPayerIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<String>mapC("getOtherPaymentPayerIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getOtherPaymentPayerIDType()).getMulti())
				.setOtherPaymentReceiverIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<String>mapC("getOtherPaymentReceiverIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getOtherPaymentReceiverIDType()).getMulti())
				.setTradeParty1ReportingDestination(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<SupervisoryBodyEnum>mapC("getTradeParty1ReportingDestination", dTCCAdditionalFields -> dTCCAdditionalFields.getTradeParty1ReportingDestination())
					.mapItem(item -> item.map("to-string", SupervisoryBodyEnum::toDisplayString)).getMulti())
				.setTradeParty2ReportingDestination(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<SupervisoryBodyEnum>mapC("getTradeParty2ReportingDestination", dTCCAdditionalFields -> dTCCAdditionalFields.getTradeParty2ReportingDestination())
					.mapItem(item -> item.map("to-string", SupervisoryBodyEnum::toDisplayString)).getMulti())
				.setClearingExceptionTypeParty2(MapperS.of(drrReport).<ClearingExceptionsAndExemptionsEnum>mapC("getClearingExceptionsAndExemptionsCounterparty2", sECTransactionReport -> sECTransactionReport.getClearingExceptionsAndExemptionsCounterparty2())
					.mapItem(item -> item.map("to-string", ClearingExceptionsAndExemptionsEnum::toDisplayString)).getMulti())
				.setClearingSwapUsiId(MapperS.of(drrReport).<String>mapC("getClearingSwapUSIs", sECTransactionReport -> sECTransactionReport.getClearingSwapUSIs()).getMulti())
				.build(), () -> HarmonizedRepeatableData.builder());
			
			final List<String> ifThenElseResult0;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult0 = MapperS.of(drrReport).<String>map("getBuyerIdentifier", sECTransactionReport -> sECTransactionReport.getBuyerIdentifier()).getMulti();
			} else {
				ifThenElseResult0 = Collections.<String>emptyList();
			}
			harmonized
				.addCdeOtherPaymentPayer(ifThenElseResult0);
			
			final List<String> ifThenElseResult1;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult1 = MapperS.of(drrReport).<String>map("getSellerIdentifier", sECTransactionReport -> sECTransactionReport.getSellerIdentifier()).getMulti();
			} else {
				ifThenElseResult1 = Collections.<String>emptyList();
			}
			harmonized
				.addCdeOtherPaymentReceiver(ifThenElseResult1);
			
			final List<String> ifThenElseResult2;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				final String string0 = "UFRO";
				ifThenElseResult2 = string0 == null ? Collections.<String>emptyList() : Collections.singletonList(string0);
			} else {
				ifThenElseResult2 = Collections.<String>emptyList();
			}
			harmonized
				.addCdeOtherPaymentType(ifThenElseResult2);
			
			final List<BigDecimal> ifThenElseResult3;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult3 = Collections.singletonList(BigDecimal.valueOf(0));
			} else {
				ifThenElseResult3 = Collections.<BigDecimal>emptyList();
			}
			harmonized
				.addCdeOtherPaymentAmount(ifThenElseResult3);
			
			final List<String> ifThenElseResult4;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult4 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).getMulti();
			} else {
				ifThenElseResult4 = Collections.<String>emptyList();
			}
			harmonized
				.addCdeOtherPaymentCurrency(ifThenElseResult4);
			
			final List<Date> ifThenElseResult5;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult5 = MapperS.of(drrReport).<Date>map("getEffectiveDate", sECTransactionReport -> sECTransactionReport.getEffectiveDate()).getMulti();
			} else {
				ifThenElseResult5 = Collections.<Date>emptyList();
			}
			harmonized
				.addCdeOtherPaymentDate(ifThenElseResult5);
			
			final List<String> ifThenElseResult6;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				final String string1 = "LEI";
				ifThenElseResult6 = string1 == null ? Collections.<String>emptyList() : Collections.singletonList(string1);
			} else {
				ifThenElseResult6 = Collections.<String>emptyList();
			}
			harmonized
				.addOtherPaymentPayerIdType(ifThenElseResult6);
			
			final List<String> ifThenElseResult7;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				final String string2 = "LEI";
				ifThenElseResult7 = string2 == null ? Collections.<String>emptyList() : Collections.singletonList(string2);
			} else {
				ifThenElseResult7 = Collections.<String>emptyList();
			}
			harmonized
				.addOtherPaymentReceiverIdType(ifThenElseResult7);
			
			return Optional.ofNullable(harmonized)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<Boolean> needsUpfrontFee(SECTransactionReport drrReport) {
			return notExists(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", sECTransactionReport -> sECTransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPayment -> otherPayment.getPaymentType())).andNullSafe(areEqual(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", sECTransactionReport -> sECTransactionReport.getDtccAdditionalFields()).<AssetClassEnum>map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()), MapperS.of(AssetClassEnum.CREDIT), CardinalityOperator.All)).andNullSafe(notExists(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<BigDecimal>map("getFixedRate", commonLeg -> commonLeg.getFixedRate()))).andNullSafe(notExists(MapperS.of(drrReport).<CommonLeg>map("getLeg1", sECTransactionReport -> sECTransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()))).asMapper();
		}
	}
}
