package drr.projection.dtcc.rds.harmonized.sec.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.projection.dtcc.rds.harmonized.sec.rewrite.trade.labels.Project_SECTradeReportToDtccRdsHarmonizedLabelProvider;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import iso20022.dtcc.rds.harmonized.Document;
import java.util.Optional;
import javax.inject.Inject;


@RuneLabelProvider(labelProvider=Project_SECTradeReportToDtccRdsHarmonizedLabelProvider.class)
@ImplementedBy(Project_SECTradeReportToDtccRdsHarmonized.Project_SECTradeReportToDtccRdsHarmonizedDefault.class)
public abstract class Project_SECTradeReportToDtccRdsHarmonized implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_SubmissionCore create_SubmissionCore;
	@Inject protected Create_SubmissionHarmonizedData create_SubmissionHarmonizedData;
	@Inject protected Create_SubmissionHarmonizedRepeatableData create_SubmissionHarmonizedRepeatableData;
	@Inject protected Create_SubmissionHeader create_SubmissionHeader;

	/**
	* @param drrReport 
	* @return harmonizedReport 
	*/
	public Document evaluate(SECTransactionReport drrReport) {
		Document.DocumentBuilder harmonizedReportBuilder = doEvaluate(drrReport);
		
		final Document harmonizedReport;
		if (harmonizedReportBuilder == null) {
			harmonizedReport = null;
		} else {
			harmonizedReport = harmonizedReportBuilder.build();
			objectValidator.validate(Document.class, harmonizedReport);
		}
		
		return harmonizedReport;
	}

	protected abstract Document.DocumentBuilder doEvaluate(SECTransactionReport drrReport);

	public static class Project_SECTradeReportToDtccRdsHarmonizedDefault extends Project_SECTradeReportToDtccRdsHarmonized {
		@Override
		protected Document.DocumentBuilder doEvaluate(SECTransactionReport drrReport) {
			Document.DocumentBuilder harmonizedReport = Document.builder();
			return assignOutput(harmonizedReport, drrReport);
		}
		
		protected Document.DocumentBuilder assignOutput(Document.DocumentBuilder harmonizedReport, SECTransactionReport drrReport) {
			harmonizedReport
				.getOrCreateSubmission()
				.setHeader(create_SubmissionHeader.evaluate(drrReport));
			
			harmonizedReport
				.getOrCreateSubmission()
				.setCore(create_SubmissionCore.evaluate(drrReport));
			
			harmonizedReport
				.getOrCreateSubmission()
				.setHarmonizedData(create_SubmissionHarmonizedData.evaluate(drrReport));
			
			harmonizedReport
				.getOrCreateSubmission()
				.setHarmonizedRepeatableData(create_SubmissionHarmonizedRepeatableData.evaluate(drrReport));
			
			return Optional.ofNullable(harmonizedReport)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
