package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.ExtractProductIdentifierBySource;
import drr.standards.iosco.cde.version3.underlier.reports.UnderlierProductIdentifierOtherRule;
import javax.inject.Inject;


@ImplementedBy(UnderlyingIdOtherSourceRule.UnderlyingIdOtherSourceRuleDefault.class)
public abstract class UnderlyingIdOtherSourceRule implements ReportFunction<TransactionReportInstruction, ProductIdTypeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected ExtractProductIdentifierBySource extractProductIdentifierBySource;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected UnderlierProductIdentifierOtherRule underlierProductIdentifierOtherRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ProductIdTypeEnum evaluate(TransactionReportInstruction input) {
		ProductIdTypeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ProductIdTypeEnum doEvaluate(TransactionReportInstruction input);

	public static class UnderlyingIdOtherSourceRuleDefault extends UnderlyingIdOtherSourceRule {
		@Override
		protected ProductIdTypeEnum doEvaluate(TransactionReportInstruction input) {
			ProductIdTypeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ProductIdTypeEnum assignOutput(ProductIdTypeEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperC<ProductIdentifier> thenArg1 = thenArg0
				.mapSingleToList(item -> MapperC.<ProductIdentifier>of(underlierProductIdentifierOtherRule.evaluate(item.get())));
			final MapperS<ProductIdentifier> thenArg2 = MapperS.of(extractProductIdentifierBySource.evaluate(thenArg1.getMulti()));
			output = thenArg2.<ProductIdTypeEnum>map("getSource", productIdentifier -> productIdentifier.getSource()).get();
			
			return output;
		}
	}
}
