package drr.regulation.cftc.rewrite.functions;

import cdm.base.staticdata.party.Party;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.base.util.party.functions.CounterpartiesForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.reports.PayoutLeg1Rule;
import drr.standards.iosco.cde.version2.party.functions.PayerParty;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(PayerPartyLeg1.PayerPartyLeg1Default.class)
public abstract class PayerPartyLeg1 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected CounterpartiesForEvent counterpartiesForEvent;
	@Inject protected PayerParty payerParty;
	@Inject protected PayoutLeg1Rule payoutLeg1Rule;

	/**
	* @param transaction 
	* @return party 
	*/
	public Party evaluate(TransactionReportInstruction transaction) {
		Party.PartyBuilder partyBuilder = doEvaluate(transaction);
		
		final Party party;
		if (partyBuilder == null) {
			party = null;
		} else {
			party = partyBuilder.build();
			objectValidator.validate(Party.class, party);
		}
		
		return party;
	}

	protected abstract Party.PartyBuilder doEvaluate(TransactionReportInstruction transaction);

	public static class PayerPartyLeg1Default extends PayerPartyLeg1 {
		@Override
		protected Party.PartyBuilder doEvaluate(TransactionReportInstruction transaction) {
			Party.PartyBuilder party = Party.builder();
			return assignOutput(party, transaction);
		}
		
		protected Party.PartyBuilder assignOutput(Party.PartyBuilder party, TransactionReportInstruction transaction) {
			party = toBuilder(payerParty.evaluate(payoutLeg1Rule.evaluate(transaction), counterpartiesForEvent.evaluate(transaction)));
			
			return Optional.ofNullable(party)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
