package drr.regulation.cftc.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.trade.ExecutionVenueTypeEnum;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(ExecutionVenueTypeRule.ExecutionVenueTypeRuleDefault.class)
public abstract class ExecutionVenueTypeRule implements ReportFunction<TransactionReportInstruction, ExecutionVenueTypeEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForCFTC isAllowableActionForCFTC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ExecutionVenueTypeEnum evaluate(TransactionReportInstruction input) {
		ExecutionVenueTypeEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract ExecutionVenueTypeEnum doEvaluate(TransactionReportInstruction input);

	public static class ExecutionVenueTypeRuleDefault extends ExecutionVenueTypeRule {
		@Override
		protected ExecutionVenueTypeEnum doEvaluate(TransactionReportInstruction input) {
			ExecutionVenueTypeEnum output = null;
			return assignOutput(output, input);
		}
		
		protected ExecutionVenueTypeEnum assignOutput(ExecutionVenueTypeEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg0 = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForCFTC.evaluate(item.get()));
			final MapperS<ReportableInformation> thenArg1 = thenArg0
				.mapSingleToItem(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()));
			output = thenArg1
				.mapSingleToItem(item -> {
					final MapperC<PartyInformation> thenArg = item.<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation())
						.filterItemNullSafe(_item -> areEqual(_item.<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()).<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.Any).get());
					if (exists(thenArg).asMapper().getOrDefault(false)) {
						return item.<ExecutionVenueTypeEnum>map("getExecutionVenueType", reportableInformation -> reportableInformation.getExecutionVenueType());
					}
					return MapperS.<ExecutionVenueTypeEnum>ofNull();
				}).get();
			
			return output;
		}
	}
}
