package drr.regulation.common.functions;

import cdm.base.datetime.Frequency;
import cdm.base.datetime.PeriodExtendedEnum;
import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.product.common.settlement.PriceQuantity;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.functions.ConvertPeriodtoISOFrequencyPeriod;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(FrequencyPeriod.FrequencyPeriodDefault.class)
public abstract class FrequencyPeriod implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected ConvertPeriodtoISOFrequencyPeriod convertPeriodtoISOFrequencyPeriod;

	/**
	* @param priceQuantity 
	* @param frequency 
	* @return period 
	*/
	public FrequencyPeriodEnum evaluate(PriceQuantity priceQuantity, Frequency frequency) {
		FrequencyPeriodEnum period = doEvaluate(priceQuantity, frequency);
		
		return period;
	}

	protected abstract FrequencyPeriodEnum doEvaluate(PriceQuantity priceQuantity, Frequency frequency);

	protected abstract MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(PriceQuantity priceQuantity, Frequency frequency);

	public static class FrequencyPeriodDefault extends FrequencyPeriod {
		@Override
		protected FrequencyPeriodEnum doEvaluate(PriceQuantity priceQuantity, Frequency frequency) {
			FrequencyPeriodEnum period = null;
			return assignOutput(period, priceQuantity, frequency);
		}
		
		protected FrequencyPeriodEnum assignOutput(FrequencyPeriodEnum period, PriceQuantity priceQuantity, Frequency frequency) {
			if (notExists(MapperS.of(frequency)).andNullSafe(exists(quantity(priceQuantity, frequency))).getOrDefault(false)) {
				period = FrequencyPeriodEnum.ADHO;
			} else {
				period = convertPeriodtoISOFrequencyPeriod.evaluate(MapperS.of(frequency).<PeriodExtendedEnum>map("getPeriod", _frequency -> _frequency.getPeriod()).get());
			}
			
			return period;
		}
		
		@Override
		protected MapperC<? extends FieldWithMetaNonNegativeQuantitySchedule> quantity(PriceQuantity priceQuantity, Frequency frequency) {
			return MapperS.of(priceQuantity).<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", _priceQuantity -> _priceQuantity.getQuantity())
				.filterItemNullSafe(item -> exists(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).andNullSafe(exists(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).orNullSafe(areEqual(MapperS.of(distinct(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule2 -> fieldWithMetaNonNegativeQuantitySchedule2 == null ? null : fieldWithMetaNonNegativeQuantitySchedule2.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue())).resultCount()), MapperS.of(1), CardinalityOperator.All))).get());
		}
	}
}
