package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.Index;
import cdm.base.staticdata.asset.common.Loan;
import cdm.base.staticdata.asset.common.Security;
import cdm.base.staticdata.asset.common.SecurityTypeEnum;
import cdm.product.asset.InterestRatePayout;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.template.Payout;
import cdm.product.template.PerformancePayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.functions.EconomicTermsForProduct;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(IsCreditTotalReturnSwap.IsCreditTotalReturnSwapDefault.class)
public abstract class IsCreditTotalReturnSwap implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;

	/**
	* @param product 
	* @return result 
	*/
	public Boolean evaluate(Product product) {
		Boolean result = doEvaluate(product);
		
		return result;
	}

	protected abstract Boolean doEvaluate(Product product);

	protected abstract MapperS<? extends Product> performanceUnderlier(Product product);

	public static class IsCreditTotalReturnSwapDefault extends IsCreditTotalReturnSwap {
		@Override
		protected Boolean doEvaluate(Product product) {
			Boolean result = null;
			return assignOutput(result, product);
		}
		
		protected Boolean assignOutput(Boolean result, Product product) {
			final ComparisonResult ifThenElseResult;
			if (exists(performanceUnderlier(product)).getOrDefault(false)) {
				ifThenElseResult = exists(performanceUnderlier(product).<Loan>map("getLoan", _product -> _product.getLoan())).orNullSafe(areEqual(performanceUnderlier(product).<Security>map("getSecurity", _product -> _product.getSecurity()).<SecurityTypeEnum>map("getSecurityType", security -> security.getSecurityType()), MapperS.of(SecurityTypeEnum.DEBT), CardinalityOperator.All)).orNullSafe(exists(performanceUnderlier(product).<Index>map("getIndex", _product -> _product.getIndex())));
			} else {
				ifThenElseResult = ComparisonResult.ofEmpty();
			}
			result = areEqual(MapperS.of(qualify_AssetClass_Credit.evaluate(economicTermsForProduct.evaluate(product))), MapperS.of(true), CardinalityOperator.All).andNullSafe(exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<InterestRatePayout>mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout())).andNullSafe(exists(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()))).andNullSafe(ifThenElseResult)).get();
			
			return result;
		}
		
		@Override
		protected MapperS<? extends Product> performanceUnderlier(Product product) {
			return MapperS.of(MapperS.of(economicTermsForProduct.evaluate(product)).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<PerformancePayout>mapC("getPerformancePayout", payout -> payout.getPerformancePayout()).get()).<Product>map("getUnderlier", performancePayout -> performancePayout.getUnderlier());
		}
	}
}
