package drr.regulation.common.trade.link.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.PartyInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportingRegime;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.metafields.FieldWithMetaSupervisoryBodyEnum;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(PostPricedSwapIndicatorRule.PostPricedSwapIndicatorRuleDefault.class)
public abstract class PostPricedSwapIndicatorRule implements ReportFunction<TransactionReportInstruction, Boolean> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Boolean evaluate(TransactionReportInstruction input) {
		Boolean output = doEvaluate(input);
		
		return output;
	}

	protected abstract Boolean doEvaluate(TransactionReportInstruction input);

	public static class PostPricedSwapIndicatorRuleDefault extends PostPricedSwapIndicatorRule {
		@Override
		protected Boolean doEvaluate(TransactionReportInstruction input) {
			Boolean output = null;
			return assignOutput(output, input);
		}
		
		protected Boolean assignOutput(Boolean output, TransactionReportInstruction input) {
			final MapperC<ReportingRegime> thenArg0 = MapperS.of(input)
				.mapSingleToList(item -> item.<ReportableInformation>map("getReportableInformation", transactionReportInstruction -> transactionReportInstruction.getReportableInformation()).<PartyInformation>mapC("getPartyInformation", reportableInformation -> reportableInformation.getPartyInformation()).<ReportingRegime>mapC("getRegimeInformation", partyInformation -> partyInformation.getRegimeInformation()));
			final MapperC<ReportingRegime> thenArg1 = thenArg0
				.filterItemNullSafe(item -> areEqual(item.<FieldWithMetaSupervisoryBodyEnum>map("getSupervisoryBody", reportingRegime -> reportingRegime.getSupervisoryBody()).<SupervisoryBodyEnum>map("Type coercion", fieldWithMetaSupervisoryBodyEnum -> fieldWithMetaSupervisoryBodyEnum == null ? null : fieldWithMetaSupervisoryBodyEnum.getValue()), MapperS.of(SupervisoryBodyEnum.CFTC), CardinalityOperator.All).get());
			final MapperS<ReportingRegime> thenArg2 = MapperS.of(thenArg1.get());
			final MapperS<Boolean> ifThenElseResult;
			if (exists(thenArg2.<Boolean>map("getPostPricedIndicator", reportingRegime -> reportingRegime.getPostPricedIndicator())).getOrDefault(false)) {
				ifThenElseResult = thenArg2.<Boolean>map("getPostPricedIndicator", reportingRegime -> reportingRegime.getPostPricedIndicator());
			} else {
				ifThenElseResult = MapperS.of(false);
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
