package drr.regulation.common.trade.price.reports;

import cdm.observable.event.Trigger;
import cdm.observable.event.TriggerEvent;
import cdm.product.template.Knock;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionPayout;
import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsOption;
import drr.base.trade.functions.EconomicTermsForProduct;
import drr.base.trade.functions.ProductForEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.price.functions.BarrierFromTriggerEvent;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(SingleOrUpperAndLowerBarrierRule.SingleOrUpperAndLowerBarrierRuleDefault.class)
public abstract class SingleOrUpperAndLowerBarrierRule implements ReportFunction<TransactionReportInstruction, SingleOrUpperAndLowerBarrier> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected BarrierFromTriggerEvent barrierFromTriggerEvent;
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected IsOption isOption;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public SingleOrUpperAndLowerBarrier evaluate(TransactionReportInstruction input) {
		SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder outputBuilder = doEvaluate(input);
		
		final SingleOrUpperAndLowerBarrier output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(SingleOrUpperAndLowerBarrier.class, output);
		}
		
		return output;
	}

	protected abstract SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder doEvaluate(TransactionReportInstruction input);

	public static class SingleOrUpperAndLowerBarrierRuleDefault extends SingleOrUpperAndLowerBarrierRule {
		@Override
		protected SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder doEvaluate(TransactionReportInstruction input) {
			SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder output = SingleOrUpperAndLowerBarrier.builder();
			return assignOutput(output, input);
		}
		
		protected SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder assignOutput(SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder output, TransactionReportInstruction input) {
			final Boolean _boolean = isOption.evaluate(productForEvent.evaluate(input));
			final MapperS<Knock> thenArg0;
			if ((_boolean == null ? false : _boolean)) {
				thenArg0 = MapperS.of(input)
					.mapSingleToItem(item -> MapperS.of(MapperS.of(economicTermsForProduct.evaluate(productForEvent.evaluate(item.get()))).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get()).<OptionFeature>map("getFeature", optionPayout -> optionPayout.getFeature()).<Knock>map("getKnock", optionFeature -> optionFeature.getKnock()));
			} else {
				thenArg0 = MapperS.<Knock>ofNull();
			}
			final MapperS<TriggerEvent> thenArg1;
			if (exists(thenArg0.<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn())).andNullSafe(notExists(thenArg0.<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()))).getOrDefault(false)) {
				thenArg1 = thenArg0.<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn());
			} else if (exists(thenArg0.<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut())).andNullSafe(notExists(thenArg0.<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn()))).getOrDefault(false)) {
				thenArg1 = thenArg0.<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut());
			} else {
				thenArg1 = MapperS.<TriggerEvent>ofNull();
			}
			final MapperS<TriggerEvent> thenArg2;
			if (exists(thenArg0.<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn())).andNullSafe(exists(thenArg0.<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()))).getOrDefault(false)) {
				if (lessThanEquals(thenArg0.<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()), thenArg0.<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()), CardinalityOperator.All).getOrDefault(false)) {
					thenArg2 = thenArg0.<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn());
				} else {
					thenArg2 = thenArg0.<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut());
				}
			} else {
				thenArg2 = MapperS.<TriggerEvent>ofNull();
			}
			final MapperS<TriggerEvent> thenArg3;
			if (exists(thenArg0.<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn())).andNullSafe(exists(thenArg0.<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()))).getOrDefault(false)) {
				if (greaterThanEquals(thenArg0.<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()), thenArg0.<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut()).<Trigger>map("getTrigger", triggerEvent -> triggerEvent.getTrigger()).<BigDecimal>map("getLevel", trigger -> trigger.getLevel()), CardinalityOperator.All).getOrDefault(false)) {
					thenArg3 = thenArg0.<TriggerEvent>map("getKnockIn", knock -> knock.getKnockIn());
				} else {
					thenArg3 = thenArg0.<TriggerEvent>map("getKnockOut", knock -> knock.getKnockOut());
				}
			} else {
				thenArg3 = MapperS.<TriggerEvent>ofNull();
			}
			output = toBuilder(MapperS.of(SingleOrUpperAndLowerBarrier.builder()
				.set_single(thenArg1
					.mapSingleToItem(item -> MapperS.of(barrierFromTriggerEvent.evaluate(item.get()))).get())
				.setLower(thenArg2
					.mapSingleToItem(item -> MapperS.of(barrierFromTriggerEvent.evaluate(item.get()))).get())
				.setUpper(thenArg3
					.mapSingleToItem(item -> MapperS.of(barrierFromTriggerEvent.evaluate(item.get()))).get())
				.build()).get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
