package drr.regulation.common.trade.quantity.reports;

import cdm.base.datetime.Frequency;
import cdm.base.math.DatedValue;
import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.FieldWithMetaNonNegativeQuantitySchedule;
import cdm.event.common.Trade;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.template.ContractualProduct;
import cdm.product.template.EconomicTerms;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Payout;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.base.qualification.product.functions.IsCommodityForward;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.trade.functions.ProductForTrade;
import drr.base.trade.functions.TradeForEvent;
import drr.base.trade.quantity.functions.CommodityForwardObservablePriceQuantity;
import drr.base.trade.quantity.functions.CommodityObservablePriceQuantity;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.CommodityLeg2;
import drr.standards.iso.functions.FormatToShortFraction5DecimalNumber;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(NotionalQuantityLeg2Rule.NotionalQuantityLeg2RuleDefault.class)
public abstract class NotionalQuantityLeg2Rule implements ReportFunction<TransactionReportInstruction, BigDecimal> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CommodityForwardObservablePriceQuantity commodityForwardObservablePriceQuantity;
	@Inject protected CommodityLeg2 commodityLeg2;
	@Inject protected CommodityObservablePriceQuantity commodityObservablePriceQuantity;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected IsCommodityForward isCommodityForward;
	@Inject protected IsCommoditySwap isCommoditySwap;
	@Inject protected ProductForTrade productForTrade;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public BigDecimal evaluate(TransactionReportInstruction input) {
		BigDecimal output = doEvaluate(input);
		
		return output;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction input);

	public static class NotionalQuantityLeg2RuleDefault extends NotionalQuantityLeg2Rule {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction input) {
			BigDecimal output = null;
			return assignOutput(output, input);
		}
		
		protected BigDecimal assignOutput(BigDecimal output, TransactionReportInstruction input) {
			final MapperS<Trade> thenArg0 = MapperS.of(input)
				.mapSingleToItem(item -> MapperS.of(tradeForEvent.evaluate(item.get())));
			final MapperS<PriceQuantity> thenArg1 = thenArg0
				.mapSingleToItem(trade -> {
					final Boolean boolean0 = isCommoditySwap.evaluate(productForTrade.evaluate(trade.get()));
					if ((boolean0 == null ? false : boolean0)) {
						return MapperS.of(commodityObservablePriceQuantity.evaluate(trade.<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), commodityLeg2.evaluate(productForTrade.evaluate(trade.get()))));
					}
					final Boolean boolean1 = isCommodityForward.evaluate(productForTrade.evaluate(trade.get()));
					if ((boolean1 == null ? false : boolean1)) {
						return MapperS.of(commodityForwardObservablePriceQuantity.evaluate(trade.<TradableProduct>map("getTradableProduct", _trade -> _trade.getTradableProduct()).<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), MapperS.of(productForTrade.evaluate(trade.get())).<ContractualProduct>map("getContractualProduct", product -> product.getContractualProduct()).<EconomicTerms>map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms()).<Payout>map("getPayout", economicTerms -> economicTerms.getPayout()).<ForwardPayout>mapC("getForwardPayout", payout -> payout.getForwardPayout()).get()));
					}
					return MapperS.<PriceQuantity>ofNull();
				});
			final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg2 = thenArg1
				.mapSingleToList(item -> item.<FieldWithMetaNonNegativeQuantitySchedule>mapC("getQuantity", priceQuantity -> priceQuantity.getQuantity()));
			final MapperC<FieldWithMetaNonNegativeQuantitySchedule> thenArg3 = thenArg2
				.filterItemNullSafe(item -> exists(item.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule -> fieldWithMetaNonNegativeQuantitySchedule == null ? null : fieldWithMetaNonNegativeQuantitySchedule.getValue()).<Frequency>map("getFrequency", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getFrequency())).get());
			final MapperC<BigDecimal> thenArg4 = thenArg3
				.mapItem(quantitySchedule -> {
					if (exists(quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule0 -> fieldWithMetaNonNegativeQuantitySchedule0 == null ? null : fieldWithMetaNonNegativeQuantitySchedule0.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue())).getOrDefault(false)) {
						return quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule1 -> fieldWithMetaNonNegativeQuantitySchedule1 == null ? null : fieldWithMetaNonNegativeQuantitySchedule1.getValue()).<BigDecimal>map("getValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getValue());
					}
					if (exists(quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule2 -> fieldWithMetaNonNegativeQuantitySchedule2 == null ? null : fieldWithMetaNonNegativeQuantitySchedule2.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue())).andNullSafe(areEqual(MapperS.of(distinct(quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule3 -> fieldWithMetaNonNegativeQuantitySchedule3 == null ? null : fieldWithMetaNonNegativeQuantitySchedule3.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue())).resultCount()), MapperS.of(1), CardinalityOperator.All)).getOrDefault(false)) {
						return quantitySchedule.<NonNegativeQuantitySchedule>map("Type coercion", fieldWithMetaNonNegativeQuantitySchedule4 -> fieldWithMetaNonNegativeQuantitySchedule4 == null ? null : fieldWithMetaNonNegativeQuantitySchedule4.getValue()).<DatedValue>mapC("getDatedValue", nonNegativeQuantitySchedule -> nonNegativeQuantitySchedule.getDatedValue()).<BigDecimal>map("getValue", datedValue -> datedValue.getValue())
							.first();
					}
					return MapperS.<BigDecimal>ofNull();
				});
			final MapperS<BigDecimal> thenArg5 = MapperS.of(distinct(thenArg4).get());
			output = MapperS.of(formatToShortFraction5DecimalNumber.evaluate(thenArg5.get())).get();
			
			return output;
		}
	}
}
