package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.csa.rewrite.trade.CSATransactionReportTrade;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 7.0.0-dev.85
 */
@RosettaDataRule("CSATransactionReportTradeDTCC_CSA_VR_0009_01")
@ImplementedBy(CSATransactionReportTradeDTCC_CSA_VR_0009_01.Default.class)
public interface CSATransactionReportTradeDTCC_CSA_VR_0009_01 extends Validator<CSATransactionReportTrade> {
	
	String NAME = "CSATransactionReportTradeDTCC_CSA_VR_0009_01";
	String DEFINITION = "if counterparty2IdentifierSource = NPID then countryAndProvinceOrTerritoryOfIndividual exists else if counterparty2IdentifierSource exists then countryAndProvinceOrTerritoryOfIndividual is absent";
	
	class Default implements CSATransactionReportTradeDTCC_CSA_VR_0009_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
			ComparisonResult result = executeDataRule(cSATransactionReportTrade);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReportTrade", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "CSATransactionReportTrade", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CSATransactionReportTrade cSATransactionReportTrade) {
			try {
				if (areEqual(MapperS.of(cSATransactionReportTrade).<Counterparty2IdentifierEnum>map("getCounterparty2IdentifierSource", _cSATransactionReportTrade -> _cSATransactionReportTrade.getCounterparty2IdentifierSource()), MapperS.of(Counterparty2IdentifierEnum.NPID), CardinalityOperator.All).getOrDefault(false)) {
					return exists(MapperS.of(cSATransactionReportTrade).<String>map("getCountryAndProvinceOrTerritoryOfIndividual", _cSATransactionReportTrade -> _cSATransactionReportTrade.getCountryAndProvinceOrTerritoryOfIndividual()));
				}
				if (exists(MapperS.of(cSATransactionReportTrade).<Counterparty2IdentifierEnum>map("getCounterparty2IdentifierSource", _cSATransactionReportTrade -> _cSATransactionReportTrade.getCounterparty2IdentifierSource())).getOrDefault(false)) {
					return notExists(MapperS.of(cSATransactionReportTrade).<String>map("getCountryAndProvinceOrTerritoryOfIndividual", _cSATransactionReportTrade -> _cSATransactionReportTrade.getCountryAndProvinceOrTerritoryOfIndividual()));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CSATransactionReportTradeDTCC_CSA_VR_0009_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReportTrade cSATransactionReportTrade) {
			return Collections.emptyList();
		}
	}
}
