package drr.regulation.fca.ukemir.refit.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.qualification.event.functions.IsVRAllowedForActionType;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.trade.underlier.UnderlyingIdentificationTypeEnum;
import drr.regulation.fca.ukemir.refit.trade.FCAUKEMIRTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 7.0.0-dev.85
 */
@RosettaDataRule("FCAUKEMIRTransactionReportUKEMIR_VR_2146_01")
@ImplementedBy(FCAUKEMIRTransactionReportUKEMIR_VR_2146_01.Default.class)
public interface FCAUKEMIRTransactionReportUKEMIR_VR_2146_01 extends Validator<FCAUKEMIRTransactionReport> {
	
	String NAME = "FCAUKEMIRTransactionReportUKEMIR_VR_2146_01";
	String DEFINITION = "if IsVRAllowedForActionType(actionType) then if assetClass = CRDT and underlyingIdentificationType = X then seriesVersion exists and seriesVersion >= 0 else seriesVersion is absent";
	
	class Default implements FCAUKEMIRTransactionReportUKEMIR_VR_2146_01 {
	
		@Inject protected IsVRAllowedForActionType isVRAllowedForActionType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			ComparisonResult result = executeDataRule(fCAUKEMIRTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "FCAUKEMIRTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			try {
				final Boolean _boolean = isVRAllowedForActionType.evaluate(MapperS.of(fCAUKEMIRTransactionReport).<ActionTypeEnum>map("getActionType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getActionType()).get());
				if ((_boolean == null ? false : _boolean)) {
					if (areEqual(MapperS.of(fCAUKEMIRTransactionReport).<CommonAssetClass>map("getAssetClass", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.CRDT), CardinalityOperator.All).andNullSafe(areEqual(MapperS.of(fCAUKEMIRTransactionReport).<UnderlyingIdentificationTypeEnum>map("getUnderlyingIdentificationType", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getUnderlyingIdentificationType()), MapperS.of(UnderlyingIdentificationTypeEnum.X), CardinalityOperator.All)).getOrDefault(false)) {
						return exists(MapperS.of(fCAUKEMIRTransactionReport).<Integer>map("getSeriesVersion", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getSeriesVersion())).andNullSafe(greaterThanEquals(MapperS.of(fCAUKEMIRTransactionReport).<Integer>map("getSeriesVersion", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getSeriesVersion()), MapperS.of(0), CardinalityOperator.All));
					}
					return notExists(MapperS.of(fCAUKEMIRTransactionReport).<Integer>map("getSeriesVersion", _fCAUKEMIRTransactionReport -> _fCAUKEMIRTransactionReport.getSeriesVersion()));
				}
				return ComparisonResult.ofEmpty();
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements FCAUKEMIRTransactionReportUKEMIR_VR_2146_01 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, FCAUKEMIRTransactionReport fCAUKEMIRTransactionReport) {
			return Collections.emptyList();
		}
	}
}
