package drr.regulation.hkma.rewrite.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.CommonTransactionInformation;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionInformation;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(Extract_UnderlyingAssetTradingPlatformIdentifier.Extract_UnderlyingAssetTradingPlatformIdentifierDefault.class)
public abstract class Extract_UnderlyingAssetTradingPlatformIdentifier implements RosettaFunction {

	/**
	* @param reportableInformation 
	* @return underlyingAssetPlatformIdentifier 
	*/
	public String evaluate(ReportableInformation reportableInformation) {
		String underlyingAssetPlatformIdentifier = doEvaluate(reportableInformation);
		
		return underlyingAssetPlatformIdentifier;
	}

	protected abstract String doEvaluate(ReportableInformation reportableInformation);

	public static class Extract_UnderlyingAssetTradingPlatformIdentifierDefault extends Extract_UnderlyingAssetTradingPlatformIdentifier {
		@Override
		protected String doEvaluate(ReportableInformation reportableInformation) {
			String underlyingAssetPlatformIdentifier = null;
			return assignOutput(underlyingAssetPlatformIdentifier, reportableInformation);
		}
		
		protected String assignOutput(String underlyingAssetPlatformIdentifier, ReportableInformation reportableInformation) {
			if (exists(MapperS.of(reportableInformation).<TransactionInformation>mapC("getTransactionInformation", _reportableInformation -> _reportableInformation.getTransactionInformation())
				.first().<CommonTransactionInformation>map("getHkmaTransactionInformation", transactionInformation -> transactionInformation.getHkmaTransactionInformation()).<String>map("getUnderlierAssetTradingPlatformIdentifier", commonTransactionInformation -> commonTransactionInformation.getUnderlierAssetTradingPlatformIdentifier())).getOrDefault(false)) {
				underlyingAssetPlatformIdentifier = MapperS.of(reportableInformation).<TransactionInformation>mapC("getTransactionInformation", _reportableInformation -> _reportableInformation.getTransactionInformation())
					.first().<CommonTransactionInformation>map("getHkmaTransactionInformation", transactionInformation -> transactionInformation.getHkmaTransactionInformation()).<String>map("getUnderlierAssetTradingPlatformIdentifier", commonTransactionInformation -> commonTransactionInformation.getUnderlierAssetTradingPlatformIdentifier()).get();
			} else {
				underlyingAssetPlatformIdentifier = null;
			}
			
			return underlyingAssetPlatformIdentifier;
		}
	}
}
