package drr.regulation.sec.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.AllocationIndicatorEnum;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.sec.rewrite.trade.functions.IsAllowableActionForSEC;
import javax.inject.Inject;


@ImplementedBy(AllocationTypeRule.AllocationTypeRuleDefault.class)
public abstract class AllocationTypeRule implements ReportFunction<TransactionReportInstruction, AllocationIndicatorEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.regulation.common.trade.event.reports.AllocationTypeRule allocationTypeRule;
	@Inject protected IsAllowableActionForSEC isAllowableActionForSEC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public AllocationIndicatorEnum evaluate(TransactionReportInstruction input) {
		AllocationIndicatorEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract AllocationIndicatorEnum doEvaluate(TransactionReportInstruction input);

	public static class AllocationTypeRuleDefault extends AllocationTypeRule {
		@Override
		protected AllocationIndicatorEnum doEvaluate(TransactionReportInstruction input) {
			AllocationIndicatorEnum output = null;
			return assignOutput(output, input);
		}
		
		protected AllocationIndicatorEnum assignOutput(AllocationIndicatorEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForSEC.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(allocationTypeRule.evaluate(item.get()))).get();
			
			return output;
		}
	}
}
