package drr.regulation.sec.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.base.trade.price.PriceFormat;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 7.0.0-dev.85
 */
@RosettaDataRule("SECTransactionReportDTCC_SEC_VR_CDEPackageTransactionPrice")
@ImplementedBy(SECTransactionReportDTCC_SEC_VR_CDEPackageTransactionPrice.Default.class)
public interface SECTransactionReportDTCC_SEC_VR_CDEPackageTransactionPrice extends Validator<SECTransactionReport> {
	
	String NAME = "SECTransactionReportDTCC_SEC_VR_CDEPackageTransactionPrice";
	String DEFINITION = "if (packageIndicator = True and packageTransactionSpread is absent) then packageTransactionPrice exists else packageTransactionPrice is absent";
	
	class Default implements SECTransactionReportDTCC_SEC_VR_CDEPackageTransactionPrice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
			ComparisonResult result = executeDataRule(sECTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SECTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "SECTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SECTransactionReport sECTransactionReport) {
			try {
				if (areEqual(MapperS.of(sECTransactionReport).<Boolean>map("getPackageIndicator", _sECTransactionReport -> _sECTransactionReport.getPackageIndicator()), MapperS.of(true), CardinalityOperator.All).andNullSafe(notExists(MapperS.of(sECTransactionReport).<PriceFormat>map("getPackageTransactionSpread", _sECTransactionReport -> _sECTransactionReport.getPackageTransactionSpread()))).getOrDefault(false)) {
					return exists(MapperS.of(sECTransactionReport).<PriceFormat>map("getPackageTransactionPrice", _sECTransactionReport -> _sECTransactionReport.getPackageTransactionPrice()));
				}
				return notExists(MapperS.of(sECTransactionReport).<PriceFormat>map("getPackageTransactionPrice", _sECTransactionReport -> _sECTransactionReport.getPackageTransactionPrice()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SECTransactionReportDTCC_SEC_VR_CDEPackageTransactionPrice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
			return Collections.emptyList();
		}
	}
}
