package drr.regulation.sec.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.sec.rewrite.trade.SECTransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

/**
 * @version 7.0.0-dev.85
 */
@RosettaDataRule("SECTransactionReportDTCC_SEC_VR_PriorUSIID")
@ImplementedBy(SECTransactionReportDTCC_SEC_VR_PriorUSIID.Default.class)
public interface SECTransactionReportDTCC_SEC_VR_PriorUSIID extends Validator<SECTransactionReport> {
	
	String NAME = "SECTransactionReportDTCC_SEC_VR_PriorUSIID";
	String DEFINITION = "if actionType = ActionTypeEnum -> NEWT and [EventTypeEnum -> NOVA, EventTypeEnum -> CLRG, EventTypeEnum -> EXER, EventTypeEnum -> ALOC, EventTypeEnum -> CLAL] any = eventType and priorUTI is absent then priorUSI exists else priorUSI is absent";
	
	class Default implements SECTransactionReportDTCC_SEC_VR_PriorUSIID {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
			ComparisonResult result = executeDataRule(sECTransactionReport);
			if (result.getOrDefault(true)) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "SECTransactionReport", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationResult.ValidationType.DATA_RULE, "SECTransactionReport", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(SECTransactionReport sECTransactionReport) {
			try {
				if (areEqual(MapperS.of(sECTransactionReport).<ActionTypeEnum>map("getActionType", _sECTransactionReport -> _sECTransactionReport.getActionType()), MapperS.of(ActionTypeEnum.NEWT), CardinalityOperator.All).andNullSafe(areEqual(MapperC.<EventTypeEnum>of(MapperS.of(EventTypeEnum.NOVA), MapperS.of(EventTypeEnum.CLRG), MapperS.of(EventTypeEnum.EXER), MapperS.of(EventTypeEnum.ALOC), MapperS.of(EventTypeEnum.CLAL)), MapperS.of(sECTransactionReport).<EventTypeEnum>map("getEventType", _sECTransactionReport -> _sECTransactionReport.getEventType()), CardinalityOperator.Any)).andNullSafe(notExists(MapperS.of(sECTransactionReport).<String>map("getPriorUTI", _sECTransactionReport -> _sECTransactionReport.getPriorUTI()))).getOrDefault(false)) {
					return exists(MapperS.of(sECTransactionReport).<String>map("getPriorUSI", _sECTransactionReport -> _sECTransactionReport.getPriorUSI()));
				}
				return notExists(MapperS.of(sECTransactionReport).<String>map("getPriorUSI", _sECTransactionReport -> _sECTransactionReport.getPriorUSI()));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements SECTransactionReportDTCC_SEC_VR_PriorUSIID {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, SECTransactionReport sECTransactionReport) {
			return Collections.emptyList();
		}
	}
}
