package drr.standards.iosco.cde.version1.quantity.functions;

import cdm.base.math.NonNegativeQuantitySchedule;
import cdm.base.math.metafields.ReferenceWithMetaNonNegativeQuantitySchedule;
import cdm.base.staticdata.party.BuyerSeller;
import cdm.base.staticdata.party.CounterpartyRoleEnum;
import cdm.base.staticdata.party.PayerReceiver;
import cdm.product.asset.ForeignExchange;
import cdm.product.common.settlement.Cashflow;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.template.OptionPayout;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.OptionTypeCode;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(OptionAmountAndCurrency.OptionAmountAndCurrencyDefault.class)
public abstract class OptionAmountAndCurrency implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param optionPayout 
	* @param optionType 
	* @return quantitySchedule 
	*/
	public NonNegativeQuantitySchedule evaluate(OptionPayout optionPayout, OptionTypeCode optionType) {
		NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantityScheduleBuilder = doEvaluate(optionPayout, optionType);
		
		final NonNegativeQuantitySchedule quantitySchedule;
		if (quantityScheduleBuilder == null) {
			quantitySchedule = null;
		} else {
			quantitySchedule = quantityScheduleBuilder.build();
			objectValidator.validate(NonNegativeQuantitySchedule.class, quantitySchedule);
		}
		
		return quantitySchedule;
	}

	protected abstract NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(OptionPayout optionPayout, OptionTypeCode optionType);

	protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> FXOptionCall(OptionPayout optionPayout, OptionTypeCode optionType);

	protected abstract MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> FXOptionPut(OptionPayout optionPayout, OptionTypeCode optionType);

	public static class OptionAmountAndCurrencyDefault extends OptionAmountAndCurrency {
		@Override
		protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder doEvaluate(OptionPayout optionPayout, OptionTypeCode optionType) {
			NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantitySchedule = NonNegativeQuantitySchedule.builder();
			return assignOutput(quantitySchedule, optionPayout, optionType);
		}
		
		protected NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder assignOutput(NonNegativeQuantitySchedule.NonNegativeQuantityScheduleBuilder quantitySchedule, OptionPayout optionPayout, OptionTypeCode optionType) {
			if (areEqual(MapperS.of(optionType), MapperS.of(OptionTypeCode.CALL), CardinalityOperator.All).getOrDefault(false)) {
				final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule0 = FXOptionCall(optionPayout, optionType).get();
				if (referenceWithMetaNonNegativeQuantitySchedule0 == null) {
					quantitySchedule = null;
				} else {
					quantitySchedule = toBuilder(referenceWithMetaNonNegativeQuantitySchedule0.getValue());
				}
			} else {
				final ReferenceWithMetaNonNegativeQuantitySchedule referenceWithMetaNonNegativeQuantitySchedule1 = FXOptionPut(optionPayout, optionType).get();
				if (referenceWithMetaNonNegativeQuantitySchedule1 == null) {
					quantitySchedule = null;
				} else {
					quantitySchedule = toBuilder(referenceWithMetaNonNegativeQuantitySchedule1.getValue());
				}
			}
			
			return Optional.ofNullable(quantitySchedule)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> FXOptionCall(OptionPayout optionPayout, OptionTypeCode optionType) {
			final MapperS<OptionPayout> thenArg = MapperS.of(optionPayout);
			final MapperS<ReferenceWithMetaNonNegativeQuantitySchedule> ifThenElseResult;
			if (areEqual(thenArg.<BuyerSeller>map("getBuyerSeller", _optionPayout -> _optionPayout.getBuyerSeller()).<CounterpartyRoleEnum>map("getBuyer", buyerSeller -> buyerSeller.getBuyer()), thenArg.<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = thenArg.<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
			} else {
				ifThenElseResult = thenArg.<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
			}
			return ifThenElseResult;
		}
		
		@Override
		protected MapperS<? extends ReferenceWithMetaNonNegativeQuantitySchedule> FXOptionPut(OptionPayout optionPayout, OptionTypeCode optionType) {
			final MapperS<OptionPayout> thenArg = MapperS.of(optionPayout);
			final MapperS<ReferenceWithMetaNonNegativeQuantitySchedule> ifThenElseResult;
			if (areEqual(thenArg.<BuyerSeller>map("getBuyerSeller", _optionPayout -> _optionPayout.getBuyerSeller()).<CounterpartyRoleEnum>map("getBuyer", buyerSeller -> buyerSeller.getBuyer()), thenArg.<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<PayerReceiver>map("getPayerReceiver", cashflow -> cashflow.getPayerReceiver()).<CounterpartyRoleEnum>map("getReceiver", payerReceiver -> payerReceiver.getReceiver()), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = thenArg.<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
			} else {
				ifThenElseResult = thenArg.<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<ForeignExchange>map("getForeignExchange", product -> product.getForeignExchange()).<Cashflow>map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).<ResolvablePriceQuantity>map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).<ReferenceWithMetaNonNegativeQuantitySchedule>map("getQuantitySchedule", resolvablePriceQuantity -> resolvablePriceQuantity.getQuantitySchedule());
			}
			return ifThenElseResult;
		}
	}
}
