/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.introspector;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.MapperConfig;
import com.fasterxml.jackson.databind.introspect.Annotated;
import com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.JacksonAnnotationIntrospector;
import com.fasterxml.jackson.databind.jsontype.TypeResolverBuilder;
import com.fasterxml.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneIgnore;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.metafields.MetaFields;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.finos.rune.mapper.introspector.RuneBeanUtil;
import org.finos.rune.mapper.introspector.RuneEnumBuilderIntrospector;
import org.finos.rune.mapper.introspector.RuneStdTypeResolverBuilder;

public class RuneJsonAnnotationIntrospector
extends JacksonAnnotationIntrospector {
    private static final long serialVersionUID = 1L;
    private static final ArrayList<String> SERIALIZATION_PROPERTY_ORDER = Lists.newArrayList((Object[])new String[]{"meta", "@ref", "@ref:external", "@ref:scoped", "@data"});
    private final RuneEnumBuilderIntrospector runeEnumBuilderIntrospector = new RuneEnumBuilderIntrospector();

    protected StdTypeResolverBuilder _constructStdTypeResolverBuilder() {
        return new RuneStdTypeResolverBuilder();
    }

    protected TypeResolverBuilder<?> _constructStdTypeResolverBuilder(MapperConfig<?> config, JsonTypeInfo.Value typeInfo, JavaType baseType) {
        return new RuneStdTypeResolverBuilder(typeInfo);
    }

    public JsonTypeInfo.Value findPolymorphicTypeInfo(MapperConfig<?> config, Annotated ann) {
        RuneDataType t = (RuneDataType)this._findAnnotation(ann, RuneDataType.class);
        if (t != null && !this.isAnnotatedTypeMetaFields(ann)) {
            return JsonTypeInfo.Value.construct((JsonTypeInfo.Id)JsonTypeInfo.Id.CLASS, (JsonTypeInfo.As)JsonTypeInfo.As.EXISTING_PROPERTY, (String)"@type", JsonTypeInfo.class, (boolean)true, (Boolean)false);
        }
        return super.findPolymorphicTypeInfo(config, ann);
    }

    public Class<?> findPOJOBuilder(AnnotatedClass ac) {
        if (ac.hasAnnotation(RuneDataType.class)) {
            return ((RuneDataType)ac.getAnnotation(RuneDataType.class)).builder();
        }
        return super.findPOJOBuilder(ac);
    }

    public PropertyName findNameForSerialization(Annotated a) {
        if (a.hasAnnotation(RuneAttribute.class)) {
            return new PropertyName(((RuneAttribute)a.getAnnotation(RuneAttribute.class)).value());
        }
        return super.findNameForSerialization(a);
    }

    public PropertyName findNameForDeserialization(Annotated a) {
        if (a.hasAnnotation(RuneAttribute.class)) {
            return new PropertyName(((RuneAttribute)a.getAnnotation(RuneAttribute.class)).value());
        }
        return super.findNameForDeserialization(a);
    }

    public NameTransformer findUnwrappingNameTransformer(AnnotatedMember member) {
        RuneMetaType ann = (RuneMetaType)this._findAnnotation((Annotated)member, RuneMetaType.class);
        if (ann == null) {
            return super.findUnwrappingNameTransformer(member);
        }
        return NameTransformer.NOP;
    }

    public JsonIgnoreProperties.Value findPropertyIgnoralByName(MapperConfig<?> config, Annotated a) {
        if (a instanceof AnnotatedClass && a.hasAnnotation(RuneDataType.class)) {
            AnnotatedClass acc = (AnnotatedClass)a;
            Set<String> includes = this.getPropertyNames(acc, x -> x.hasAnnotation(RuneAttribute.class));
            Set<String> ignored = this.getPropertyNames(acc, x -> !x.hasAnnotation(RuneAttribute.class));
            ignored.removeAll(includes);
            return JsonIgnoreProperties.Value.forIgnoredProperties(ignored).withAllowSetters();
        }
        return super.findPropertyIgnoralByName(config, a);
    }

    public String[] findEnumValues(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[] names) {
        if (this.runeEnumBuilderIntrospector.isApplicable(enumType)) {
            this.runeEnumBuilderIntrospector.findEnumValues(enumType, enumValues, names);
            return names;
        }
        return super.findEnumValues(config, enumType, (Enum[])enumValues, names);
    }

    public void findEnumAliases(MapperConfig<?> config, AnnotatedClass enumType, Enum<?>[] enumValues, String[][] aliasList) {
        if (this.runeEnumBuilderIntrospector.isApplicable(enumType)) {
            this.runeEnumBuilderIntrospector.findEnumAliases(enumType, enumValues, aliasList);
        } else {
            super.findEnumAliases(config, enumType, (Enum[])enumValues, aliasList);
        }
    }

    public String[] findSerializationPropertyOrder(AnnotatedClass ac) {
        if (ac.hasAnnotation(RuneDataType.class)) {
            return SERIALIZATION_PROPERTY_ORDER.toArray(new String[0]);
        }
        return super.findSerializationPropertyOrder(ac);
    }

    public boolean hasIgnoreMarker(AnnotatedMember a) {
        return a.getName().startsWith("add") || a.hasAnnotation(RuneIgnore.class) || super.hasIgnoreMarker(a);
    }

    private Set<String> getPropertyNames(AnnotatedClass acc, Predicate<AnnotatedMethod> filter) {
        return StreamSupport.stream(acc.memberMethods().spliterator(), false).filter(filter).map(RuneBeanUtil::getPropertyName).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    private boolean isAnnotatedTypeMetaFields(Annotated ann) {
        return ann.getType().getRawClass() == MetaFields.class;
    }

    public Version version() {
        return Version.unknownVersion();
    }
}

