/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.processor.collector;

import com.rosetta.model.lib.GlobalKey;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.meta.FieldWithMeta;
import com.rosetta.model.lib.meta.GlobalKeyFields;
import com.rosetta.model.lib.meta.Key;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.finos.rune.mapper.processor.KeyRecord;
import org.finos.rune.mapper.processor.collector.CollectorStrategy;
import org.finos.rune.mapper.processor.collector.KeyLookupService;

public class KeyCollectorStrategy
implements CollectorStrategy {
    private final Map<KeyRecord, Object> globalKeyToValueObjectMap = new HashMap<KeyRecord, Object>();
    private final Map<KeyRecord, Object> externalKeyToValueObjectMap = new HashMap<KeyRecord, Object>();
    private final Map<KeyRecord, Object> addressToValueObjectMap = new HashMap<KeyRecord, Object>();

    @Override
    public void collect(RosettaModelObject instance) {
        if (instance instanceof GlobalKey) {
            GlobalKey globalKey = (GlobalKey)instance;
            Object value = this.getValue(instance);
            Class<?> valueClass = this.getValueType(instance);
            if (value != null && valueClass != null) {
                Optional.ofNullable(globalKey.getMeta()).map(GlobalKeyFields::getGlobalKey).ifPresent(gk -> this.globalKeyToValueObjectMap.put(new KeyRecord(valueClass, (String)gk), value));
                Optional.ofNullable(globalKey.getMeta()).map(GlobalKeyFields::getExternalKey).ifPresent(ek -> this.externalKeyToValueObjectMap.put(new KeyRecord(valueClass, (String)ek), value));
                Optional.ofNullable(globalKey.getMeta()).map(GlobalKeyFields::getKey).ifPresent(keys -> keys.stream().map(Key::getKeyValue).filter(Objects::nonNull).forEach(kv -> this.addressToValueObjectMap.put(new KeyRecord(valueClass, (String)kv), value)));
            }
        }
    }

    public KeyLookupService getKeyLookupService() {
        return new KeyLookupService(this.globalKeyToValueObjectMap, this.externalKeyToValueObjectMap, this.addressToValueObjectMap);
    }

    private Object getValue(RosettaModelObject instance) {
        if (instance instanceof FieldWithMeta) {
            return ((FieldWithMeta)instance).getValue();
        }
        return instance;
    }

    private Class<?> getValueType(RosettaModelObject builder) {
        if (builder instanceof FieldWithMeta) {
            return ((FieldWithMeta)builder).getValueType();
        }
        return builder.getType();
    }
}

