/*
 * Decompiled with CFR 0.152.
 */
package drr.base.margin.functions;

import cdm.event.common.CollateralBalance;
import cdm.event.common.CollateralStatusEnum;
import cdm.event.common.HaircutIndicatorEnum;
import cdm.observable.asset.Money;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetMarginValueDefault.class)
public abstract class GetMarginValue
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public Money evaluate(List<? extends CollateralBalance> partyCollateralBalances, HaircutIndicatorEnum haircutType) {
        Money marginValue;
        Money.MoneyBuilder marginValueBuilder = this.doEvaluate(partyCollateralBalances, haircutType);
        if (marginValueBuilder == null) {
            marginValue = null;
        } else {
            marginValue = marginValueBuilder.build();
            this.objectValidator.validate(Money.class, (RosettaModelObject)marginValue);
        }
        return marginValue;
    }

    protected abstract Money.MoneyBuilder doEvaluate(List<? extends CollateralBalance> var1, HaircutIndicatorEnum var2);

    public static class GetMarginValueDefault
    extends GetMarginValue {
        @Override
        protected Money.MoneyBuilder doEvaluate(List<? extends CollateralBalance> partyCollateralBalances, HaircutIndicatorEnum haircutType) {
            if (partyCollateralBalances == null) {
                partyCollateralBalances = Collections.emptyList();
            }
            Money.MoneyBuilder marginValue = Money.builder();
            return this.assignOutput(marginValue, partyCollateralBalances, haircutType);
        }

        protected Money.MoneyBuilder assignOutput(Money.MoneyBuilder marginValue, List<? extends CollateralBalance> partyCollateralBalances, HaircutIndicatorEnum haircutType) {
            MapperC thenArg0 = MapperC.of(partyCollateralBalances).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getHaircutIndicator", collateralBalance -> collateralBalance.getHaircutIndicator()), (Mapper)MapperS.of((Object)haircutType), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg1 = thenArg0.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getCollateralBalanceStatus", collateralBalance -> collateralBalance.getCollateralBalanceStatus()), (Mapper)MapperS.of((Object)CollateralStatusEnum.FULL_AMOUNT), (CardinalityOperator)CardinalityOperator.All).get());
            MapperC thenArg2 = thenArg1.mapItem(item -> item.map("getAmountBaseCurrency", collateralBalance -> collateralBalance.getAmountBaseCurrency()));
            marginValue = (Money.MoneyBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((Money)thenArg2.get())).get());
            return Optional.ofNullable(marginValue).map(o -> o.prune()).orElse(null);
        }
    }
}

