/*
 * Decompiled with CFR 0.152.
 */
package drr.base.qualification.product.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommodityForward;
import drr.base.trade.functions.EconomicTermsForProduct;
import javax.inject.Inject;

@ImplementedBy(value=IsCommodityFloatingPriceForwardDefault.class)
public abstract class IsCommodityFloatingPriceForward
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommodityForward isCommodityForward;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    public static class IsCommodityFloatingPriceForwardDefault
    extends IsCommodityFloatingPriceForward {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            result = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isCommodityForward.evaluate(product)), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.economicTermsForProduct.evaluate(product)).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()))).get();
            return result;
        }
    }
}

