/*
 * Decompiled with CFR 0.152.
 */
package drr.base.qualification.product.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.qualification.product.functions.IsCommoditySwap;
import drr.base.trade.functions.EconomicTermsForProduct;
import javax.inject.Inject;

@ImplementedBy(value=IsCommoditySwap_SingleIndexDefault.class)
public abstract class IsCommoditySwap_SingleIndex
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected IsCommoditySwap isCommoditySwap;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Product var1);

    protected abstract MapperC<? extends Product> commodityUnderlier(Product var1);

    public static class IsCommoditySwap_SingleIndexDefault
    extends IsCommoditySwap_SingleIndex {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            result = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.isCommoditySwap.evaluate(product)), (Mapper)MapperS.of((Object)true), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getSettlementTerms", commodityPayout -> commodityPayout.getSettlementTerms()).map("getSettlementType", settlementTerms -> settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)this.commodityUnderlier(product).map("getCommodity", _product -> _product.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()).map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).map("getSource", productIdentifier -> productIdentifier.getSource()), (Mapper)MapperS.of((Object)ProductIdTypeEnum.ISDACRP), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)this.commodityUnderlier(product).map("getIndex", _product -> _product.getIndex()).mapC("getProductTaxonomy", index -> index.getProductTaxonomy()).map("getPrimaryAssetClass", productTaxonomy -> productTaxonomy.getPrimaryAssetClass()).map("Type coercion", fieldWithMetaAssetClassEnum -> fieldWithMetaAssetClassEnum.getValue()), (Mapper)MapperS.of((Object)AssetClassEnum.COMMODITY), (CardinalityOperator)CardinalityOperator.Any))).get();
            return result;
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product));
        }

        @Override
        protected MapperC<? extends Product> commodityUnderlier(Product product) {
            return this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getUnderlier", commodityPayout -> commodityPayout.getUnderlier());
        }
    }
}

