/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.price.functions;

import cdm.event.common.Trade;
import cdm.event.position.CounterpartyPosition;
import cdm.observable.asset.PriceSchedule;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.base.trade.ReportableEventBase;
import drr.base.trade.functions.PositionForEvent;
import drr.base.trade.functions.TradeForEvent;
import drr.base.trade.price.functions.SingleTradeLot;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=Contract_PriceDefault.class)
public abstract class Contract_Price
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected PositionForEvent positionForEvent;
    @Inject
    protected SingleTradeLot singleTradeLot;
    @Inject
    protected TradeForEvent tradeForEvent;

    public List<? extends PriceSchedule> evaluate(ReportableEventBase reportableEvent) {
        List prices;
        List<PriceSchedule.PriceScheduleBuilder> pricesBuilder = this.doEvaluate(reportableEvent);
        if (pricesBuilder == null) {
            prices = null;
        } else {
            prices = pricesBuilder.stream().map(PriceSchedule::build).collect(Collectors.toList());
            this.objectValidator.validate(PriceSchedule.class, prices);
        }
        return prices;
    }

    protected abstract List<PriceSchedule.PriceScheduleBuilder> doEvaluate(ReportableEventBase var1);

    protected abstract MapperS<? extends Trade> trade(ReportableEventBase var1);

    protected abstract MapperS<? extends CounterpartyPosition> position(ReportableEventBase var1);

    public static class Contract_PriceDefault
    extends Contract_Price {
        @Override
        protected List<PriceSchedule.PriceScheduleBuilder> doEvaluate(ReportableEventBase reportableEvent) {
            ArrayList<PriceSchedule.PriceScheduleBuilder> prices = new ArrayList<PriceSchedule.PriceScheduleBuilder>();
            return this.assignOutput(prices, reportableEvent);
        }

        protected List<PriceSchedule.PriceScheduleBuilder> assignOutput(List<PriceSchedule.PriceScheduleBuilder> prices, ReportableEventBase reportableEvent) {
            if (ExpressionOperatorsNullSafe.exists(this.trade(reportableEvent)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                prices.addAll(this.toBuilder(MapperS.of((Object)this.singleTradeLot.evaluate((Trade)this.trade(reportableEvent).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
            } else if (ExpressionOperatorsNullSafe.exists(this.position(reportableEvent)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                prices.addAll(this.toBuilder(MapperS.of((Object)((TradeLot)this.position(reportableEvent).map("getPositionBase", counterpartyPosition -> counterpartyPosition.getPositionBase()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get())).mapC("getPriceQuantity", tradeLot -> tradeLot.getPriceQuantity()).mapC("getPrice", priceQuantity -> priceQuantity.getPrice()).map("Type coercion", fieldWithMetaPriceSchedule -> fieldWithMetaPriceSchedule.getValue()).getMulti()));
            } else {
                prices.addAll(this.toBuilder(Collections.emptyList()));
            }
            return Optional.ofNullable(prices).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }

        @Override
        protected MapperS<? extends Trade> trade(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.tradeForEvent.evaluate(reportableEvent));
        }

        @Override
        protected MapperS<? extends CounterpartyPosition> position(ReportableEventBase reportableEvent) {
            return MapperS.of((Object)this.positionForEvent.evaluate(reportableEvent));
        }
    }
}

