/*
 * Decompiled with CFR 0.152.
 */
package drr.base.trade.price.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.observable.asset.PriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.base.trade.price.PriceNotationEnum;
import drr.base.trade.price.functions.NotationFromPrice;
import drr.standards.iso.functions.ConvertNonISOToISOCurrency;
import javax.inject.Inject;

@ImplementedBy(value=CurrencyFromPriceDefault.class)
public abstract class CurrencyFromPrice
implements RosettaFunction {
    @Inject
    protected ConvertNonISOToISOCurrency convertNonISOToISOCurrency;
    @Inject
    protected NotationFromPrice notationFromPrice;

    public ISOCurrencyCodeEnum evaluate(PriceSchedule price) {
        ISOCurrencyCodeEnum currency = this.doEvaluate(price);
        return currency;
    }

    protected abstract ISOCurrencyCodeEnum doEvaluate(PriceSchedule var1);

    public static class CurrencyFromPriceDefault
    extends CurrencyFromPrice {
        @Override
        protected ISOCurrencyCodeEnum doEvaluate(PriceSchedule price) {
            ISOCurrencyCodeEnum currency = null;
            return this.assignOutput(currency, price);
        }

        protected ISOCurrencyCodeEnum assignOutput(ISOCurrencyCodeEnum currency, PriceSchedule price) {
            MapperS thenArg0 = MapperS.of((Object)price);
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)this.notationFromPrice.evaluate((PriceSchedule)item.get()))), (Mapper)MapperS.of((Object)((Object)PriceNotationEnum.MONETARY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getUnit", priceSchedule -> priceSchedule.getUnit()).map("getCurrency", unitType -> unitType.getCurrency());
                }
                return MapperS.ofNull();
            });
            currency = (ISOCurrencyCodeEnum)thenArg1.mapSingleToItem(item -> {
                FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)item.get();
                return MapperS.of((Object)this.convertNonISOToISOCurrency.evaluate(fieldWithMetaString == null ? null : fieldWithMetaString.getValue()));
            }).get();
            return currency;
        }
    }
}

